/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record TamedLootCondition(LootContext.EntityTarget tamed, Optional<LootContext.EntityTarget> owner) implements LootItemCondition
{
    public static final MapCodec<TamedLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LootContext.EntityTarget.CODEC.fieldOf("tamed_entity").forGetter(TamedLootCondition::tamed), (App)LootContext.EntityTarget.CODEC.optionalFieldOf("owner_entity").forGetter(TamedLootCondition::owner)).apply((Applicative)inst, TamedLootCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(this.tamed.getParam());
        if (!(entity instanceof TamableAnimal)) {
            return false;
        }
        TamableAnimal tamableAnimal = (TamableAnimal)entity;
        return this.owner.isEmpty() && tamableAnimal.getOwnerUUID() == null || this.owner.isPresent() && tamableAnimal.getOwner() == context.getParamOrNull(this.owner.get().getParam());
    }

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final LootContext.EntityTarget tamed;
        @Nullable
        private Optional<LootContext.EntityTarget> owner = Optional.empty();

        protected Builder(LootContext.EntityTarget tamed) {
            this.tamed = tamed;
        }

        public static Builder builder(LootContext.EntityTarget tamed) {
            return new Builder(tamed);
        }

        public Builder ownerEntity(LootContext.EntityTarget owner) {
            this.owner = Optional.of(owner);
            return this;
        }

        @NotNull
        public TamedLootCondition build() {
            return new TamedLootCondition(this.tamed, this.owner);
        }
    }
}

