/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class SplitToPlanksFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SplitToPlanksFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> SplitToPlanksFunction.commonFields((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SplitToPlanksFunction::new));
    public static final LootItemFunctionType<SplitToPlanksFunction> TYPE = new LootItemFunctionType(CODEC);

    public SplitToPlanksFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    @NotNull
    public LootItemFunctionType<SplitToPlanksFunction> getType() {
        return TYPE;
    }

    @NotNull
    protected ItemStack run(ItemStack stack, @NotNull LootContext context) {
        if (!stack.is(EnchiridionTags.ItemTags.CAN_SPLIT)) {
            return stack;
        }
        Optional logKey = stack.getItemHolder().unwrapKey();
        if (logKey.isEmpty()) {
            return stack;
        }
        ItemStack mapItem = Enchiridion.getHelper().getItemForSplittingEnchantment((Holder<Item>)stack.getItemHolder());
        if (mapItem != null) {
            return mapItem.copyWithCount(stack.getCount());
        }
        ResourceLocation match = ((ResourceKey)logKey.get()).location().withPath(string -> {
            String[] split = string.split("_");
            return string.replace("stripped_", "").replace(split[split.length - 1], "") + "planks";
        });
        Item plankItem = (Item)BuiltInRegistries.ITEM.get(match);
        return stack.transmuteCopy((ItemLike)plankItem);
    }
}

