/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.subpredicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ArmorStandSubPredicate(Optional<Boolean> isMarker) implements EntitySubPredicate
{
    public static final MapCodec<ArmorStandSubPredicate> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("is_marker").forGetter(ArmorStandSubPredicate::isMarker)).apply((Applicative)inst, ArmorStandSubPredicate::new));

    public boolean matches(@NotNull Entity entity, @NotNull ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof ArmorStand)) {
            return false;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        return this.isMarker.isEmpty() || this.isMarker.get().booleanValue() == armorStand.isMarker();
    }

    @NotNull
    public MapCodec<ArmorStandSubPredicate> codec() {
        return CODEC;
    }

    public static class Builder {
        private Optional<Boolean> isMarker = Optional.empty();

        protected Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder expansion(boolean isMarker) {
            this.isMarker = Optional.of(isMarker);
            return this;
        }

        public ArmorStandSubPredicate build() {
            return new ArmorStandSubPredicate(this.isMarker);
        }
    }
}

