/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.util;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class ItemDropUtil {
    public static List<ItemStack> dropSkulls(LivingEntity entity, @Nullable Player lastDamagePlayer, DamageSource source) {
        ServerLevel serverLevel;
        Level level;
        block11: {
            block10: {
                level = entity.level();
                if (!(level instanceof ServerLevel)) break block10;
                serverLevel = (ServerLevel)level;
                level = source.getEntity();
                if (level instanceof LivingEntity) break block11;
            }
            return List.of();
        }
        LivingEntity attacker = (LivingEntity)level;
        ResourceKey<LootTable> resourceKey = Enchiridion.getHelper().getSkullLootTableForEntity((Holder<EntityType<?>>)entity.getType().builtInRegistryHolder());
        if (resourceKey == null) {
            return List.of();
        }
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(resourceKey);
        if (lootTable == LootTable.EMPTY) {
            return List.of();
        }
        LootParams.Builder params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        EquipmentSlot slot = EquipmentSlot.MAINHAND;
        for (EquipmentSlot slot1 : EquipmentSlot.values()) {
            if (attacker.getItemBySlot(slot1) != attacker.getWeaponItem()) continue;
            slot = slot1;
        }
        EquipmentSlot finalSlot = slot;
        boolean dropSkull = false;
        block1: for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)attacker.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), attacker.getWeaponItem()).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.DROP_SKULL).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(finalSlot)).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.DROP_SKULL)) {
                if (!effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty()))) continue;
                dropSkull = true;
                break block1;
            }
        }
        if (dropSkull) {
            LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
            if (lastDamagePlayer != null) {
                lootBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)lastDamagePlayer).withLuck(lastDamagePlayer.getLuck());
            }
            return lootTable.getRandomItems(lootBuilder.create(LootContextParamSets.ENTITY));
        }
        return List.of();
    }
}

