/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.util;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.IncrementalUseEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.OptionalConditionalEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.duck.Duck_AutoUse;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.mutable.MutableFloat;

public class ItemUtil {
    public static void autoUse(LivingEntity entity) {
        ServerLevel level;
        block12: {
            block11: {
                Level level2 = entity.level();
                if (!(level2 instanceof ServerLevel)) break block11;
                level = (ServerLevel)level2;
                if (!entity.getUseItem().isEmpty()) break block12;
            }
            return;
        }
        int useDuration = entity.getUseItem().getUseDuration(entity);
        if (useDuration == 0) {
            return;
        }
        ItemEnchantments enchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), entity.getUseItem());
        LootParams.Builder params = new LootParams.Builder(level);
        params.withParameter(LootContextParams.TOOL, (Object)entity.getUseItem());
        MutableFloat mutable = new MutableFloat(Float.NaN);
        EquipmentSlot slot = entity.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        for (Object2IntMap.Entry entry2 : enchantments.entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.INCREMENTAL_USE).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.INCREMENTAL_USE)) {
                if (!effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                mutable.setValue(((IncrementalUseEffect)effect.effect()).autoUseOffset().process(entry2.getIntValue(), level.getRandom(), mutable.isNaN() ? (float)useDuration : mutable.getValue().floatValue()));
            }
        }
        for (Object2IntMap.Entry entry2 : enchantments.entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.AUTO_USE).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.AUTO_USE)) {
                if (!effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                mutable.setValue(((EnchantmentValueEffect)effect.effect()).process(entry2.getIntValue(), level.getRandom(), mutable.isNaN() ? 0.0f : mutable.getValue().floatValue()));
            }
        }
        if (mutable.isNaN()) {
            return;
        }
        int value = Mth.floor((float)mutable.getValue().floatValue());
        if (value < 1) {
            value = 1;
        }
        if ((entity.getTicksUsingItem() != 0 || useDuration == 1) && Math.min(entity.getTicksUsingItem() + 1, useDuration) % value == 0 && entity instanceof Duck_AutoUse) {
            Duck_AutoUse preventionAccess = (Duck_AutoUse)entity;
            preventionAccess.enchiridion$setAutoUsing(true);
            entity.releaseUsingItem();
        }
    }

    public static int modifyItemUseDuration(ServerLevel level, Entity entity, EquipmentSlot slot, ItemStack stack, int original) {
        if (original == 0) {
            return original;
        }
        ItemEnchantments enchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack);
        LootParams.Builder params = new LootParams.Builder(level);
        params.withParameter(LootContextParams.TOOL, (Object)stack);
        MutableFloat mutable = new MutableFloat((float)original);
        for (Object2IntMap.Entry entry2 : enchantments.entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.INCREMENTAL_USE).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
            block1: for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.INCREMENTAL_USE)) {
                if (!effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                mutable.setValue(((IncrementalUseEffect)effect.effect()).useTimeBase().process(entry2.getIntValue(), level.getRandom(), mutable.getValue().floatValue()));
                for (int i = 0; i < Enchiridion.getHelper().getUseAmount(entity); ++i) {
                    float previousAmount = mutable.getValue().floatValue();
                    mutable.setValue(((IncrementalUseEffect)effect.effect()).useTimeIncrement().process(entry2.getIntValue(), level.getRandom(), mutable.getValue().floatValue()));
                    if (Mth.equal((float)previousAmount, (float)mutable.getValue().floatValue())) continue block1;
                }
            }
        }
        for (Object2IntMap.Entry entry2 : enchantments.entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.USE_TIME).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.USE_TIME)) {
                if (!effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                mutable.setValue(((EnchantmentValueEffect)effect.effect()).process(entry2.getIntValue(), level.getRandom(), mutable.getValue().floatValue()));
            }
        }
        int value = Mth.floor((float)mutable.getValue().floatValue());
        if (value < 1) {
            value = 1;
        }
        return value;
    }

    public static boolean preventsPostItemUse(ServerLevel level, EquipmentSlot slot, ItemStack stack, LivingEntity entity) {
        ItemEnchantments enchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack);
        LootParams.Builder params = new LootParams.Builder(level);
        params.withParameter(LootContextParams.TOOL, (Object)stack);
        for (Object2IntMap.Entry entry2 : enchantments.entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PREVENT_POST_ITEM_USE).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
            for (OptionalConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PREVENT_POST_ITEM_USE)) {
                if (!effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ITEM)).create(Optional.empty()))) continue;
                if (effect.effect().isPresent()) {
                    ((EnchantmentEntityEffect)effect.effect().get()).apply(level, entry2.getIntValue(), new EnchantedItemInUse(stack, slot, entity), (Entity)entity, entity.position());
                }
                return true;
            }
        }
        return false;
    }

    public static void onUseItem(ServerLevel level, LivingEntity entity, ItemStack stack, EquipmentSlot slot) {
        ItemEnchantments enchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack);
        LootParams.Builder params = new LootParams.Builder(level);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        for (Object2IntMap.Entry entry2 : enchantments.entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.USE_ITEM).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
            for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.USE_ITEM)) {
                if (!effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()))) continue;
                ((EnchantmentEntityEffect)effect.effect()).apply(level, entry2.getIntValue(), new EnchantedItemInUse(stack, slot, entity), (Entity)entity, entity.position());
            }
        }
    }
}

