/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import org.jetbrains.annotations.NotNull;

public record ClampedEnchantmentValue(Optional<LevelBasedValue> min, Optional<LevelBasedValue> max) implements EnchantmentValueEffect
{
    public static final MapCodec<ClampedEnchantmentValue> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.optionalFieldOf("min").forGetter(ClampedEnchantmentValue::min), (App)LevelBasedValue.CODEC.optionalFieldOf("max").forGetter(ClampedEnchantmentValue::max)).apply((Applicative)inst, ClampedEnchantmentValue::new));

    public static ClampedEnchantmentValue min(LevelBasedValue min) {
        return new ClampedEnchantmentValue(Optional.of(min), Optional.empty());
    }

    public static ClampedEnchantmentValue max(LevelBasedValue max) {
        return new ClampedEnchantmentValue(Optional.empty(), Optional.of(max));
    }

    public static ClampedEnchantmentValue between(LevelBasedValue min, LevelBasedValue max) {
        return new ClampedEnchantmentValue(Optional.of(min), Optional.of(max));
    }

    public float process(int enchantmentLevel, @NotNull RandomSource random, float value) {
        if (this.max.isPresent() && value > this.max.get().calculate(enchantmentLevel)) {
            return this.max.get().calculate(enchantmentLevel);
        }
        if (this.min.isPresent() && value < this.min.get().calculate(enchantmentLevel)) {
            return this.min.get().calculate(enchantmentLevel);
        }
        return value;
    }

    @NotNull
    public MapCodec<? extends EnchantmentValueEffect> codec() {
        return CODEC;
    }
}

