/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import org.jetbrains.annotations.NotNull;

public record UniformEnchantmentValue(LevelBasedValue min, LevelBasedValue max, Operation operation) implements EnchantmentValueEffect
{
    public static final MapCodec<UniformEnchantmentValue> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.fieldOf("min").forGetter(UniformEnchantmentValue::min), (App)LevelBasedValue.CODEC.fieldOf("max").forGetter(UniformEnchantmentValue::max), (App)Operation.CODEC.fieldOf("operation").forGetter(UniformEnchantmentValue::operation)).apply((Applicative)inst, UniformEnchantmentValue::new));

    public float process(int enchantmentLevel, @NotNull RandomSource random, float value) {
        float minBound = this.min.calculate(enchantmentLevel);
        float maxBound = this.max.calculate(enchantmentLevel);
        float newValue = Mth.randomBetween((RandomSource)random, (float)minBound, (float)maxBound);
        return switch (this.operation.ordinal()) {
            case 0 -> value + newValue;
            case 1 -> value * newValue;
            default -> newValue;
        };
    }

    @NotNull
    public MapCodec<? extends EnchantmentValueEffect> codec() {
        return CODEC;
    }

    public static enum Operation implements StringRepresentable
    {
        ADD("add"),
        MULTIPLY("multiply"),
        SET("set");

        public static final Codec<Operation> CODEC;
        private final String name;

        private Operation(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Operation::values);
        }
    }
}

