/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.block;

import com.mojang.serialization.MapCodec;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.block.entity.SiphoningTableBlockEntity;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiphoningTableBlock
extends BaseEntityBlock
implements SculkBehaviour {
    public static final MapCodec<SiphoningTableBlock> CODEC = SiphoningTableBlock.simpleCodec(SiphoningTableBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public SiphoningTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public MapCodec<SiphoningTableBlock> codec() {
        return CODEC;
    }

    protected boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SiphoningTableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? SiphoningTableBlock.createTickerHelper(blockEntityType, EnchiridionBlockEntityTypes.SIPHONING_TABLE, SiphoningTableBlockEntity::bookAnimationTick) : SiphoningTableBlock.createTickerHelper(blockEntityType, EnchiridionBlockEntityTypes.SIPHONING_TABLE, SiphoningTableBlockEntity::tick);
    }

    public void animateTick(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Optional blockEntity = level.getBlockEntity(pos, EnchiridionBlockEntityTypes.SIPHONING_TABLE);
        if (blockEntity.isPresent()) {
            int particleChance;
            int n = particleChance = ((SiphoningTableBlockEntity)((Object)blockEntity.get())).isSiphoning() ? 9 : 1;
            if (((SiphoningTableBlockEntity)((Object)blockEntity.get())).getExperience() > 0 && level.random.nextInt(12) < particleChance) {
                Vec3 particlePos = pos.getCenter().add((double)random.nextFloat() * 0.6 - 0.3, 0.3, (double)random.nextFloat() * 0.6 - 0.3);
                level.addParticle((ParticleOptions)new SculkChargeParticleOptions(0.0f), particlePos.x(), particlePos.y(), particlePos.z(), 0.0, 0.01, 0.0);
            }
            if (((SiphoningTableBlockEntity)((Object)blockEntity.get())).isSiphoning()) {
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, random.nextDouble() - 0.5, 0.6 * random.nextDouble() + 0.4, random.nextDouble() - 0.5);
            }
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof SiphoningTableBlockEntity) {
            SiphoningTableBlockEntity blockEntity = (SiphoningTableBlockEntity)blockentity;
            Enchiridion.getHelper().openMenu(player, blockEntity, pos);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    protected MenuProvider getMenuProvider(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof SiphoningTableBlockEntity) {
            SiphoningTableBlockEntity blockEntity = (SiphoningTableBlockEntity)blockentity;
            return blockEntity;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) return;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SiphoningTableBlockEntity) {
            SiphoningTableBlockEntity siphoningBE = (SiphoningTableBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)siphoningBE);
                super.onRemove(state, level, pos, newState, isMoving);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
                return;
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    public int attemptUseCharge(SculkSpreader.ChargeCursor cursor, LevelAccessor level, @NotNull BlockPos pos, @NotNull RandomSource random, @NotNull SculkSpreader spreader, boolean shouldConvertBlocks) {
        Optional blockEntity = level.getBlockEntity(cursor.getPos(), EnchiridionBlockEntityTypes.SIPHONING_TABLE);
        int charge = cursor.getCharge();
        if (blockEntity.isPresent()) {
            if (((SiphoningTableBlockEntity)((Object)blockEntity.get())).getExperience() < 15) {
                int remainingExperience = charge - Math.max(charge, 15 - ((SiphoningTableBlockEntity)((Object)blockEntity.get())).getExperience());
                ((SiphoningTableBlockEntity)((Object)blockEntity.get())).giveExperiencePoints(charge);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 effectPos = cursor.getPos().getCenter().add(0.0, 0.2, 0.0);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SCULK_SOUL, effectPos.x(), effectPos.y(), effectPos.z(), (int)((double)charge * 1.5) + 1, 0.2, 0.2, 0.2, 0.02);
                    serverLevel.addFreshEntity((Entity)new ExperienceOrb((Level)serverLevel, (double)cursor.getPos().getX(), (double)cursor.getPos().getY() + 0.7, (double)cursor.getPos().getZ() + 0.5, remainingExperience));
                }
            }
            return 0;
        }
        return charge;
    }
}

