/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.block.entity;

import com.google.common.collect.Lists;
import house.greenhouse.enchiridion.menu.SiphoningInput;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import house.greenhouse.enchiridion.registry.EnchiridionSoundEvents;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiphoningTableBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider,
WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    public static final int MAXIMUM_EXPERIENCE = 15;
    private static final RandomSource RANDOM = RandomSource.create();
    private final NonNullList<ItemStack> items;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeChecker quickCheck;
    public int time;
    public float bookY;
    public float oldBookY;
    public float flip;
    public float oldFlip;
    public float flipT;
    public float flipA;
    public float rot;
    public float oldRot;
    public float tRot;
    public float open = 1.5f;
    private int enchantTime;
    private int enchantTimeTotal;
    private int experience;
    private boolean siphoning;
    @Nullable
    private Component name;

    public SiphoningTableBlockEntity(BlockPos pos, BlockState state) {
        super(EnchiridionBlockEntityTypes.SIPHONING_TABLE, pos, state);
        this.items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        this.quickCheck = new RecipeChecker();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SiphoningTableBlockEntity siphoningTable) {
        SiphoningInput input;
        Optional<RecipeHolder<SiphoningRecipe>> optionalRecipe;
        boolean didInventoryChange = false;
        boolean shouldDrain = true;
        if (siphoningTable.hasInput() && (optionalRecipe = siphoningTable.quickCheck.getRecipeFor(input = new SiphoningInput((Container)siphoningTable), level)).isPresent()) {
            ItemStack newItem = ((SiphoningRecipe)optionalRecipe.get().value()).assemble(input, (HolderLookup.Provider)level.registryAccess());
            if (!ItemStack.isSameItemSameComponents((ItemStack)siphoningTable.getItem(2), (ItemStack)newItem) && (siphoningTable.isSiphoning() || siphoningTable.getExperience() >= ((SiphoningRecipe)optionalRecipe.get().value()).getExperienceCost()) && siphoningTable.canStackWithResultSlot(newItem)) {
                RecipeHolder<SiphoningRecipe> recipe = optionalRecipe.get();
                didInventoryChange = siphoningTable.processEnchanting((SiphoningRecipe)recipe.value(), newItem);
                if (!siphoningTable.siphoning) {
                    siphoningTable.siphoning = true;
                    siphoningTable.setChanged();
                }
                shouldDrain = false;
            }
        }
        if (shouldDrain) {
            siphoningTable.enchantTime = Math.max(0, siphoningTable.enchantTime - 4);
            if (siphoningTable.siphoning) {
                siphoningTable.siphoning = false;
                siphoningTable.setChanged();
            }
        }
        if (didInventoryChange) {
            siphoningTable.setChanged();
        }
    }

    public static void bookAnimationTick(Level level, BlockPos pos, BlockState state, SiphoningTableBlockEntity siphoningTable) {
        float f2;
        if (!siphoningTable.hasBook() && siphoningTable.getItem(2).isEmpty() && siphoningTable.getItem(3).isEmpty()) {
            if (siphoningTable.time > 0) {
                siphoningTable.time = 0;
                siphoningTable.bookY = 0.0f;
                siphoningTable.oldBookY = 0.0f;
                siphoningTable.flip = 0.0f;
                siphoningTable.oldFlip = 0.0f;
                siphoningTable.flipT = 0.0f;
                siphoningTable.flipA = 0.0f;
                siphoningTable.rot = 0.0f;
                siphoningTable.oldRot = 0.0f;
                siphoningTable.tRot = 0.0f;
                siphoningTable.open = 1.5f;
            }
            return;
        }
        siphoningTable.oldRot = siphoningTable.rot;
        siphoningTable.oldBookY = siphoningTable.bookY;
        Player player = level.getNearestPlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0, false);
        if (siphoningTable.isSiphoning()) {
            float bookYStart = 0.2f;
            if (siphoningTable.hasBook()) {
                if (player != null) {
                    double d0 = player.getX() - ((double)pos.getX() + 0.5);
                    double d1 = player.getZ() - ((double)pos.getZ() + 0.5);
                    siphoningTable.tRot = (float)Mth.atan2((double)d1, (double)d0);
                }
                if (RANDOM.nextInt(40) == 0) {
                    float f1 = siphoningTable.flipT;
                    do {
                        siphoningTable.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                    } while (f1 == siphoningTable.flipT);
                }
                siphoningTable.open = Math.max(siphoningTable.open - 0.05f, 1.0f);
                bookYStart = 0.1f;
            }
            siphoningTable.bookY = bookYStart + Mth.sin((float)((float)siphoningTable.time * bookYStart)) * 0.01f;
        } else {
            siphoningTable.tRot = 0.0f;
            siphoningTable.bookY = Math.max(siphoningTable.bookY - (siphoningTable.hasBook() ? 0.02f : 0.1f), 0.0f);
            siphoningTable.open = Math.min(siphoningTable.open + 0.05f, 1.2f);
        }
        while (siphoningTable.rot >= (float)Math.PI) {
            siphoningTable.rot -= (float)Math.PI * 2;
        }
        while (siphoningTable.rot < (float)(-Math.PI)) {
            siphoningTable.rot += (float)Math.PI * 2;
        }
        while (siphoningTable.tRot >= (float)Math.PI) {
            siphoningTable.tRot -= (float)Math.PI * 2;
        }
        while (siphoningTable.tRot < (float)(-Math.PI)) {
            siphoningTable.tRot += (float)Math.PI * 2;
        }
        for (f2 = siphoningTable.tRot - siphoningTable.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        siphoningTable.rot += f2 * 0.4f;
        ++siphoningTable.time;
        siphoningTable.oldFlip = siphoningTable.flip;
        float f = (siphoningTable.flipT - siphoningTable.flip) * 0.4f;
        f = Mth.clamp((float)f, (float)-0.2f, (float)0.2f);
        siphoningTable.flipA += (f - siphoningTable.flipA) * 0.9f;
        siphoningTable.flip += siphoningTable.flipA;
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> items) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.items.set(i, (Object)(items.size() < i ? ItemStack.EMPTY : (ItemStack)items.get(i)));
        }
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt("enchant_time", this.enchantTime);
        tag.putInt("enchant_time_total", this.enchantTimeTotal);
        tag.putInt("xp", this.experience);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.enchantTime = tag.getInt("enchant_time");
        this.enchantTimeTotal = tag.getInt("enchant_time_total");
        this.experience = tag.getInt("xp");
        this.siphoning = tag.getBoolean("has_recipe");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt("enchant_time", this.enchantTime);
        tag.putInt("enchant_time_total", this.enchantTimeTotal);
        tag.putInt("xp", this.experience);
        tag.putBoolean("has_recipe", this.siphoning);
        return tag;
    }

    public int getExperience() {
        return this.experience;
    }

    public void giveExperiencePoints(int xpPoints) {
        this.experience = Math.clamp((long)(this.experience + xpPoints), 0, 15);
        this.setChanged();
    }

    public int getEnchantTime() {
        return this.enchantTime;
    }

    public int getEnchantTimeTotal() {
        return this.enchantTimeTotal;
    }

    private boolean processEnchanting(SiphoningRecipe recipe, ItemStack assembled) {
        if (this.level == null) {
            return false;
        }
        ++this.enchantTime;
        this.enchantTimeTotal = recipe.getTime();
        if (this.enchantTime < this.enchantTimeTotal) {
            if ((this.enchantTimeTotal - this.enchantTime) % (this.enchantTimeTotal / recipe.getExperienceCost()) == 0) {
                --this.experience;
            }
            this.setChanged();
            return false;
        }
        this.enchantTime = 0;
        this.enchantTimeTotal = 0;
        for (int i = 0; i < 3; ++i) {
            int shrinkAmount = i == 2 ? 1 : recipe.getIngredientCosts().get(i);
            ItemStack stack = (ItemStack)this.items.get(i);
            stack.shrink(shrinkAmount);
            this.items.set(i, (Object)stack);
        }
        if (((ItemStack)this.items.get(3)).isEmpty()) {
            this.items.set(3, (Object)assembled);
        } else {
            ((ItemStack)this.items.get(3)).grow(1);
        }
        this.level.playSound(null, this.getBlockPos(), EnchiridionSoundEvents.SIPHONING_TABLE_FINISH, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.8f);
        return true;
    }

    private boolean canStackWithResultSlot(ItemStack result) {
        ItemStack resultItem = (ItemStack)this.items.get(3);
        return resultItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)resultItem, (ItemStack)result) && resultItem.getCount() + result.getCount() < resultItem.getMaxStackSize();
    }

    private boolean hasInput() {
        return !this.items.subList(0, 3).stream().filter(stack -> !stack.isEmpty()).toList().isEmpty();
    }

    public boolean hasBook() {
        return this.getItem(2).is(Items.BOOK) || this.getItem(2).is(Items.ENCHANTED_BOOK) || this.getItem(3).is(Items.ENCHANTED_BOOK);
    }

    public boolean isSiphoning() {
        return this.siphoning;
    }

    public void awardUsedRecipes(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAward(player.serverLevel());
        player.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            player.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAward(ServerLevel level) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(list::add);
        }
        return list;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(@Nullable Component customName) {
        this.name = customName;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.enchiridion.siphon");
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.id(), 1);
        }
    }

    public void fillStackedContents(@NotNull StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.accountStack(stack);
        }
    }

    public int getContainerSize() {
        return 4;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, @NotNull Inventory inventory) {
        return new SiphoningMenu(containerId, inventory, this);
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction direction) {
        if (direction == Direction.DOWN) {
            return new int[]{3};
        }
        if (direction.getAxis().isHorizontal()) {
            return new int[]{0, 1};
        }
        return new int[]{2};
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (direction == null) {
            return false;
        }
        if (direction == Direction.DOWN) {
            return index == 3;
        }
        if (direction.getAxis().isHorizontal()) {
            return index == 0 || index == 1;
        }
        return direction == Direction.UP;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (direction == Direction.DOWN) {
            return index == 3;
        }
        if (direction.getAxis().isHorizontal()) {
            return index == 0 || index == 1;
        }
        return direction == Direction.UP;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        this.quickCheck.checkNewRecipe();
    }

    public static class RecipeChecker
    implements RecipeManager.CachedCheck<SiphoningInput, SiphoningRecipe> {
        @Nullable
        private ResourceLocation lastRecipe;
        private boolean checkNewRecipe = true;

        protected RecipeChecker() {
        }

        @NotNull
        public Optional<RecipeHolder<SiphoningRecipe>> getRecipeFor(@NotNull SiphoningInput input, Level level) {
            RecipeHolder recipeHolder;
            SiphoningRecipe siphoning;
            Recipe recipe;
            Optional lastOptional;
            RecipeManager recipeManager = level.getRecipeManager();
            Optional optional = lastOptional = this.lastRecipe == null ? Optional.empty() : recipeManager.byKey(this.lastRecipe);
            if (!this.checkNewRecipe && lastOptional.isPresent() && (recipe = ((RecipeHolder)lastOptional.get()).value()) instanceof SiphoningRecipe && (siphoning = (SiphoningRecipe)recipe).matches(input, level)) {
                recipeHolder = (RecipeHolder)lastOptional.get();
                return Optional.of(recipeHolder);
            }
            Optional<RecipeHolder> optional2 = recipeManager.getAllRecipesFor(EnchiridionRecipeTypes.SIPHONING).stream().filter(holder -> ((SiphoningRecipe)holder.value()).matches(input, level)).max(Comparator.comparingInt(value -> ((SiphoningRecipe)value.value()).getEnchantments().values().stream().mapToInt(itemEnchantments -> itemEnchantments.entrySet().stream().map(Object2IntMap.Entry::getIntValue).max(Comparator.comparingInt(value2 -> value2)).orElse(0)).max().orElse(0)));
            if (optional2.isPresent()) {
                recipeHolder = optional2.get();
                this.lastRecipe = recipeHolder.id();
                this.checkNewRecipe = false;
                return Optional.of(recipeHolder);
            }
            return Optional.empty();
        }

        protected void checkNewRecipe() {
            this.checkNewRecipe = true;
        }
    }
}

