/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.CategoryVisuals;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.client.platform.EnchiridionClientPlatformHelper;
import house.greenhouse.enchiridion.client.renderer.block.SiphoningTableRenderer;
import house.greenhouse.enchiridion.client.renderer.entity.WhirlpoolRenderer;
import house.greenhouse.enchiridion.client.renderer.entity.model.WhirlpoolModel;
import house.greenhouse.enchiridion.duck.Duck_ClientSmashDamageSource;
import house.greenhouse.enchiridion.mixin.Accessor_ItemEnchantments;
import house.greenhouse.enchiridion.registry.EnchiridionBlockEntityTypes;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEntityTypes;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EnchiridionClient {
    public static Duck_ClientSmashDamageSource smashAttacker = null;
    private static EnchiridionClientPlatformHelper helper;
    private static ItemColor originalEnchantedBookColorGetter;

    public static void init(EnchiridionClientPlatformHelper helper) {
        if (EnchiridionClient.helper != null) {
            return;
        }
        EnchiridionClient.helper = helper;
        ItemProperties.register((Item)Items.ENCHANTED_BOOK, (ResourceLocation)Enchiridion.id("colored"), (stack, level, entity, seed) -> {
            ItemEnchantments storedEnchantments;
            if (level != null && ((Accessor_ItemEnchantments)(storedEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY))).enchiridion$shouldShowInTooltip() && !storedEnchantments.isEmpty()) {
                Holder<EnchantmentCategory> first = EnchantmentCategoryUtil.getFirstEnchantmentCategory((HolderLookup.Provider)level.registryAccess(), (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY), (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY));
                if (first == null || !first.isBound()) {
                    return Float.NEGATIVE_INFINITY;
                }
                Optional<CategoryVisuals> configValue = Objects.requireNonNull(((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).client()).getBookVisuals(first);
                if (configValue.isPresent() && configValue.get().bookColor() != null && configValue.get().itemModelIndex() == null) {
                    return 1.0f;
                }
                if (((EnchantmentCategory)first.value()).visuals().itemModelIndex() != null && ((EnchantmentCategory)first.value()).visuals().bookColor() != null && ((EnchantmentCategory)first.value()).visuals().itemModelIndex() == null) {
                    return 1.0f;
                }
            }
            return Float.NEGATIVE_INFINITY;
        });
        ItemProperties.register((Item)Items.ENCHANTED_BOOK, (ResourceLocation)Enchiridion.id("first_enchantment_category"), (stack, level, entity, seed) -> {
            ItemEnchantments storedEnchantments;
            if (level != null && ((Accessor_ItemEnchantments)(storedEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY))).enchiridion$shouldShowInTooltip() && !storedEnchantments.isEmpty()) {
                Holder<EnchantmentCategory> first = EnchantmentCategoryUtil.getFirstEnchantmentCategory((HolderLookup.Provider)level.registryAccess(), (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY), (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY));
                if (first == null || !first.isBound()) {
                    return Float.NEGATIVE_INFINITY;
                }
                Optional<CategoryVisuals> configValue = Objects.requireNonNull(((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).client()).getBookVisuals(first);
                if (configValue.isPresent() && configValue.get().itemModelIndex() != null) {
                    return configValue.get().itemModelIndex().floatValue();
                }
                Float modelIndex = ((EnchantmentCategory)first.value()).visuals().itemModelIndex();
                return modelIndex != null ? modelIndex.floatValue() : Float.NEGATIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        });
    }

    public static EnchiridionClientPlatformHelper getHelper() {
        return helper;
    }

    public static void registerItemColors(Function<ItemLike, ItemColor> getter, BiConsumer<ItemColor, List<ItemLike>> setter) {
        originalEnchantedBookColorGetter = getter.apply((ItemLike)Items.ENCHANTED_BOOK);
        setter.accept((stack, index) -> {
            Holder<EnchantmentCategory> first;
            ItemEnchantments storedEnchantments;
            ClientLevel level;
            if (index == 4959 && (level = Minecraft.getInstance().level) != null && ((Accessor_ItemEnchantments)(storedEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY))).enchiridion$shouldShowInTooltip() && !storedEnchantments.isEmpty() && (first = EnchantmentCategoryUtil.getFirstEnchantmentCategory((HolderLookup.Provider)level.registryAccess(), (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY), (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY))) != null && first.isBound()) {
                Optional<CategoryVisuals> configValue = Objects.requireNonNull(((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).client()).getBookVisuals(first);
                if (configValue.isPresent() && configValue.get().bookColor() != null && configValue.get().itemModelIndex() == null) {
                    return FastColor.ARGB32.opaque((int)configValue.get().bookColor().getValue());
                }
                if (((EnchantmentCategory)first.value()).visuals().bookColor() != null && ((EnchantmentCategory)first.value()).visuals().itemModelIndex() == null) {
                    return FastColor.ARGB32.opaque((int)((EnchantmentCategory)first.value()).visuals().bookColor().getValue());
                }
            }
            if (originalEnchantedBookColorGetter != null) {
                originalEnchantedBookColorGetter.getColor(stack, index);
            }
            return -1;
        }, List.of(Items.ENCHANTED_BOOK));
    }

    public static void registerBlockEntityRenderers(BiConsumer<BlockEntityType<?>, BlockEntityRendererProvider> consumer) {
        consumer.accept(EnchiridionBlockEntityTypes.SIPHONING_TABLE, SiphoningTableRenderer::new);
    }

    public static void registerEntityRenderers(BiConsumer<EntityType<?>, EntityRendererProvider> consumer) {
        consumer.accept(EnchiridionEntityTypes.WHIRLPOOL, WhirlpoolRenderer::new);
    }

    public static void registerEntityModelLayers(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> consumer) {
        consumer.accept(WhirlpoolModel.LAYER_LOCATION, WhirlpoolModel::createBodyLayer);
    }
}

