/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.screen;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.client.screen.recipebook.SiphoningRecipeBookComponent;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SiphoningScreen
extends AbstractContainerScreen<SiphoningMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation SIPHONING_TABLE_LOCATION = Enchiridion.id("textures/gui/container/siphoning_table.png");
    private static final ResourceLocation SIPHON_INDICATOR_SPRITE_LOCATION = Enchiridion.id("container/siphoning_table/siphon_indicator");
    private static final ResourceLocation SIPHONING_PROGRESS_SPRITE_LOCATION = Enchiridion.id("container/siphoning_table/siphoning_progress");
    private static final ResourceLocation EXPERIENCE_BAR_SPRITE_LOCATION = Enchiridion.id("container/siphoning_table/experience_bar");
    private static final int INDICATOR_DURATION = 40;
    private final SiphoningRecipeBookComponent recipeBookComponent = new SiphoningRecipeBookComponent();
    private float indicatorTick = 0.0f;
    private boolean widthTooNarrow;

    public SiphoningScreen(SiphoningMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void init() {
        super.init();
        boolean bl = this.widthTooNarrow = this.width < 379;
        if (this.minecraft != null) {
            this.recipeBookComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
        }
        this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 8, this.height / 2 - 49, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, button -> {
            this.recipeBookComponent.toggleVisibility();
            this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
            button.setPosition(this.leftPos + 8, this.height / 2 - 49);
        }));
        this.addWidget((GuiEventListener)this.recipeBookComponent);
        this.setInitialFocus((GuiEventListener)this.recipeBookComponent);
        this.titleLabelX = 37;
    }

    public void containerTick() {
        super.containerTick();
        this.recipeBookComponent.tick();
    }

    public void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = this.leftPos;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(SIPHONING_TABLE_LOCATION, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((SiphoningMenu)this.menu).isSiphoning()) {
            if (this.indicatorTick > 40.0f) {
                this.indicatorTick = 0.0f;
            }
            guiGraphics.blitSprite(SIPHON_INDICATOR_SPRITE_LOCATION, 16, 11, 0, 0, this.leftPos + 45, this.topPos + 35, 16, this.getMagicSpriteFill());
            this.indicatorTick += partialTick;
        } else {
            this.indicatorTick = 0.0f;
        }
        guiGraphics.blitSprite(SIPHONING_PROGRESS_SPRITE_LOCATION, 43, 14, 0, 0, this.leftPos + 68, this.topPos + 50, ((SiphoningMenu)this.menu).getEnchantingProgressFill(), 14);
        guiGraphics.blitSprite(EXPERIENCE_BAR_SPRITE_LOCATION, 16, 4, 0, 0, this.leftPos + 45, this.topPos + 66, ((SiphoningMenu)this.menu).getExperienceBarFill(), 4);
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        if (this.recipeBookComponent.isVisible() && this.widthTooNarrow) {
            this.renderBackground(gui, mouseX, mouseY, partialTick);
            this.recipeBookComponent.render(gui, mouseX, mouseY, partialTick);
        } else {
            super.render(gui, mouseX, mouseY, partialTick);
            this.recipeBookComponent.render(gui, mouseX, mouseY, partialTick);
            this.recipeBookComponent.renderGhostRecipe(gui, this.leftPos, this.topPos, true, partialTick);
        }
        this.renderTooltip(gui, mouseX, mouseY);
        this.recipeBookComponent.renderTooltip(gui, this.leftPos, this.topPos, mouseX, mouseY);
    }

    protected void renderTooltip(@NotNull GuiGraphics gui, int x, int y) {
        if (((SiphoningMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack itemstack = this.hoveredSlot.getItem();
            gui.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), x, y);
        }
        if (!this.recipeBookComponent.shouldRenderRecipeBookExperienceTooltip((SiphoningMenu)this.menu)) {
            this.renderExperienceTooltip(gui, x, y);
        }
    }

    private void renderExperienceTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        if (this.isHovering(45, 66, 16, 4, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.translatable((String)"container.enchiridion.siphon.sculk_catalyst"));
            if (this.minecraft != null) {
                if (this.minecraft.options.advancedItemTooltips) {
                    components.add(Component.translatable((String)"container.enchiridion.siphon.experience_amount", (Object[])new Object[]{Component.literal((String)String.valueOf(((SiphoningMenu)this.getMenu()).getExperience())), Component.literal((String)String.valueOf(15))}).withStyle(ChatFormatting.DARK_GRAY));
                }
                gui.renderComponentTooltip(this.minecraft.font, components, mouseX, mouseY);
            }
        }
    }

    private int getMagicSpriteFill() {
        return Mth.ceil((float)(this.indicatorTick / 40.0f * 11.0f));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.recipeBookComponent.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.recipeBookComponent.charTyped(codePoint, modifiers) || super.charTyped(codePoint, modifiers);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.isVisible()) && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.recipeBookComponent.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.isVisible() || super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        boolean flag = mouseX < (double)guiLeft || mouseY < (double)guiTop || mouseX >= (double)(guiLeft + this.imageWidth) || mouseY >= (double)(guiTop + this.imageHeight);
        return this.recipeBookComponent.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, mouseButton) && flag;
    }

    protected void slotClicked(@NotNull Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        this.recipeBookComponent.slotClicked(slot);
    }

    public void recipesUpdated() {
        this.recipeBookComponent.recipesUpdated();
    }

    @NotNull
    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookComponent;
    }
}

