/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.screen.recipebook;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.client.screen.recipebook.SiphoningRecipeBookPage;
import house.greenhouse.enchiridion.menu.SiphoningInput;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.menu.recipebook.SiphoningStackedContents;
import house.greenhouse.enchiridion.mixin.Invoker_EnchantmentHelper;
import house.greenhouse.enchiridion.mixin.client.Accessor_RecipeBookComponent;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiphoningRecipeBookComponent
extends RecipeBookComponent {
    private static final WidgetSprites FILTER_SPRITES = new WidgetSprites(Enchiridion.id("recipe_book/siphoning_filter_enabled"), Enchiridion.id("recipe_book/siphoning_filter_disabled"), Enchiridion.id("recipe_book/siphoning_filter_enabled_highlighted"), Enchiridion.id("recipe_book/siphoning_filter_disabled_highlighted"));
    private static final Component FILTER_NAME = Component.translatable((String)"enchiridion.gui.recipebook.toggleRecipes.siphonable");
    private NonNullList<ItemStack> previousContainer = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private int previousExperience = 0;

    public void initVisuals() {
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof SiphoningMenu) {
            SiphoningMenu siphoningMenu = (SiphoningMenu)recipeBookMenu;
            ((Accessor_RecipeBookComponent)((Object)this)).enchiridion$setRecipeBookPage(new SiphoningRecipeBookPage());
            ((Accessor_RecipeBookComponent)((Object)this)).enchiridion$setStackedContents(new SiphoningStackedContents(siphoningMenu));
        }
        super.initVisuals();
    }

    public void slotClicked(@Nullable Slot slot) {
        if (slot != null && slot.index < 3) {
            this.ghostRecipe.clear();
        }
    }

    public void tick() {
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof SiphoningMenu) {
            SiphoningMenu siphoningMenu = (SiphoningMenu)recipeBookMenu;
            if (((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getSelectedTab() != null) {
                NonNullList<ItemStack> container = this.containerList(siphoningMenu);
                if (!container.equals(this.previousContainer)) {
                    this.ghostRecipe.clear();
                    this.previousContainer = container;
                } else if (this.previousExperience != siphoningMenu.getExperience()) {
                    this.updateCollections(false);
                } else if (siphoningMenu.isSiphoning() && !siphoningMenu.getBlockEntity().isEmpty() && this.minecraft.level != null) {
                    this.menu.fillCraftSlotsStackedContents(((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents());
                    SiphoningInput input = new SiphoningInput((Container)siphoningMenu.getBlockEntity());
                    Optional<RecipeHolder> recipe = this.minecraft.level.getRecipeManager().getAllRecipesFor(EnchiridionRecipeTypes.SIPHONING).stream().filter(holder -> ((SiphoningRecipe)holder.value()).matches(input, (Level)this.minecraft.level)).max(Comparator.comparingInt(value -> ((SiphoningRecipe)value.value()).getEnchantments().values().stream().map(itemEnchantments -> itemEnchantments.entrySet().stream().mapToInt(Object2IntMap.Entry::getIntValue).max().orElse(0)).max(Comparator.comparingInt(value1 -> value1)).orElse(0)));
                    recipe.filter(holder -> ((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)((Object)this))).enchiridion$getStackedContents()).currentRecipe != holder.value()).ifPresent(siphoningRecipeRecipeHolder -> {
                        ((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)((Object)this))).enchiridion$getStackedContents()).currentRecipe = siphoningRecipeRecipeHolder.value();
                        this.updateCollections(false);
                    });
                } else if (!siphoningMenu.isSiphoning() && ((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents()).currentRecipe != null) {
                    this.menu.fillCraftSlotsStackedContents(((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents());
                    ((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents()).currentRecipe = null;
                    this.updateCollections(false);
                }
                this.previousExperience = siphoningMenu.getExperience();
            }
        }
    }

    private NonNullList<ItemStack> containerList(SiphoningMenu siphoningMenu) {
        NonNullList container = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 3; ++i) {
            container.set(i, (Object)siphoningMenu.getBlockEntity().getItem(i));
        }
        return container;
    }

    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(FILTER_SPRITES);
    }

    @NotNull
    protected Component getRecipeFilterName() {
        return FILTER_NAME;
    }

    public void renderTooltip(@NotNull GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY) {
        SiphoningMenu siphoningMenu;
        super.renderTooltip(gui, renderX, renderY, mouseX, mouseY);
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof SiphoningMenu && this.shouldRenderRecipeBookExperienceTooltip(siphoningMenu = (SiphoningMenu)recipeBookMenu) && this.ghostRecipe.getRecipe() != null && (recipeBookMenu = this.ghostRecipe.getRecipe().value()) instanceof SiphoningRecipe) {
            SiphoningRecipe siphoningRecipe = (SiphoningRecipe)recipeBookMenu;
            this.renderExperienceTooltip(siphoningMenu, siphoningRecipe, gui, renderX, renderY, mouseX, mouseY);
        }
    }

    private void renderExperienceTooltip(SiphoningMenu menu, SiphoningRecipe recipe, GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY) {
        if (this.isHovering(45, 66, 16, 4, mouseX - renderX, mouseY - renderY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(Component.translatable((String)"container.enchiridion.siphon.experience_points.more"));
            components.add(Component.translatable((String)"container.enchiridion.siphon.sculk_catalyst"));
            if (this.minecraft.options.advancedItemTooltips) {
                components.add(Component.translatable((String)"container.enchiridion.siphon.experience_amount", (Object[])new Object[]{Component.literal((String)String.valueOf(menu.getExperience())), Component.literal((String)String.valueOf(recipe.getExperienceCost()))}).withStyle(ChatFormatting.DARK_GRAY));
            }
            gui.renderComponentTooltip(this.minecraft.font, components, mouseX, mouseY);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldRenderRecipeBookExperienceTooltip(SiphoningMenu siphoningMenu) {
        if (this.ghostRecipe.getRecipe() == null) return false;
        Recipe recipe = this.ghostRecipe.getRecipe().value();
        if (!(recipe instanceof SiphoningRecipe)) return false;
        SiphoningRecipe siphoningRecipe = (SiphoningRecipe)recipe;
        if (((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents()).currentRecipe != null) {
            if (((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents()).currentRecipe != siphoningRecipe) return false;
        }
        if (siphoningMenu.getExperience() >= siphoningRecipe.getExperienceCost()) return false;
        return true;
    }

    public void renderGhostRecipe(@NotNull GuiGraphics gui, int leftPos, int topPos, boolean singleItem, float partialTick) {
        if (this.ghostRecipe.getRecipe() == null) {
            return;
        }
        super.renderGhostRecipe(gui, leftPos, topPos, singleItem, partialTick);
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof SiphoningMenu) {
            SiphoningMenu siphoningMenu = (SiphoningMenu)recipeBookMenu;
            recipeBookMenu = this.ghostRecipe.getRecipe().value();
            if (recipeBookMenu instanceof SiphoningRecipe) {
                SiphoningRecipe siphoningRecipe = (SiphoningRecipe)recipeBookMenu;
                if ((((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents()).currentRecipe == null || ((SiphoningStackedContents)((Accessor_RecipeBookComponent)((Object)this)).enchiridion$getStackedContents()).currentRecipe != siphoningRecipe) && siphoningMenu.getExperience() < siphoningRecipe.getExperienceCost()) {
                    gui.fill(leftPos + 45, topPos + 66, leftPos + 45 + 16, topPos + 66 + 4, 0x30FF0000);
                }
            }
        }
    }

    private boolean isHovering(int x, int y, int xWidth, int yWidth, int mouseX, int mouseY) {
        int maxX = x + xWidth;
        int maxY = y + yWidth;
        return mouseX >= x && mouseX <= maxX && mouseY >= y && mouseY <= maxY;
    }

    public void setupGhostRecipe(@NotNull RecipeHolder<?> recipe, @NotNull List<Slot> slots) {
        SiphoningRecipe siphoningRecipe;
        List supportedItems;
        this.ghostRecipe.setRecipe(recipe);
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof SiphoningRecipe && !(supportedItems = (siphoningRecipe = (SiphoningRecipe)recipe2).getEnchantments().entrySet().stream().flatMap(entry -> ((ItemEnchantments)entry.getValue()).entrySet().stream().flatMap(entry1 -> ((Enchantment)((Holder)entry1.getKey()).value()).getSupportedItems().stream())).toList()).isEmpty()) {
            Ingredient enchantableIngredient = Ingredient.of(Stream.concat(supportedItems.stream().filter(Holder::isBound).map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance()), BuiltInRegistries.ITEM.getTag(EnchiridionTags.ItemTags.STORED_ENCHANTABLES).stream().flatMap(named -> named.stream().map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance()))));
            enchantableIngredient.getItems();
            this.ghostRecipe.addIngredient(Ingredient.of(Arrays.stream(enchantableIngredient.getItems()).map(stack -> this.assemble((ItemStack)stack, siphoningRecipe))), ((Slot)this.menu.slots.get((int)3)).x, ((Slot)this.menu.slots.get((int)3)).y);
            this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipe, Stream.concat(recipe.value().getIngredients().stream(), Stream.of(enchantableIngredient)).iterator(), 0);
        }
        this.updateCollections(false);
    }

    public ItemStack assemble(ItemStack originalStack, SiphoningRecipe recipe) {
        ItemStack stack = originalStack.is(Items.BOOK) ? new ItemStack((Holder)Items.ENCHANTED_BOOK.builtInRegistryHolder(), originalStack.getCount(), originalStack.getComponentsPatch()) : originalStack.copy();
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
        EnchantmentHelper.updateEnchantments((ItemStack)stack, enchantments -> {
            for (Map.Entry<Holder<EnchantmentCategory>, ItemEnchantments> entry : recipe.getEnchantments().entrySet()) {
                for (Object2IntMap.Entry enchantment : entry.getValue().entrySet()) {
                    if (!((Holder)enchantment.getKey()).isBound() || !categories.isValid(entry.getKey(), (Holder<Enchantment>)((Holder)enchantment.getKey())) || !((Enchantment)((Holder)enchantment.getKey()).value()).isSupportedItem(stack) && Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack) != DataComponents.STORED_ENCHANTMENTS) {
                        return;
                    }
                    enchantments.upgrade((Holder)enchantment.getKey(), enchantment.getIntValue());
                    ItemEnchantmentCategories.Mutable mutableCategories = new ItemEnchantmentCategories.Mutable(categories);
                    mutableCategories.add(entry.getKey(), (Holder<Enchantment>)((Holder)enchantment.getKey()));
                }
            }
        });
        stack.set(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)categories);
        return stack;
    }
}

