/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.menu.slot;

import house.greenhouse.enchiridion.block.entity.SiphoningTableBlockEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SiphoningResultSlot
extends Slot {
    private final Player player;
    private int removeCount;

    public SiphoningResultSlot(Player player, Container container, int slot, int xPosition, int yPosition) {
        super(container, slot, xPosition, yPosition);
        this.player = player;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(player, stack);
    }

    protected void onQuickCraft(@NotNull ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)player;
            player = this.container;
            if (player instanceof SiphoningTableBlockEntity) {
                SiphoningTableBlockEntity blockEntity = (SiphoningTableBlockEntity)player;
                blockEntity.awardUsedRecipes(serverplayer);
            }
        }
        this.removeCount = 0;
    }
}

