/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.google.common.collect.Sets;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.mixin.Accessor_CommandSourceStack;
import house.greenhouse.enchiridion.network.clientbound.SendEnchantmentCategoryFromCommandClientboundPacket;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.server.commands.EnchantCommand;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantCommand.class})
public class Mixin_EnchantCommand {
    @Inject(method={"enchant"}, at={@At(value="INVOKE", target="Ljava/util/Collection;size()I")})
    private static void enchiridion$sendEnchantCommandCategoryForColoring(CommandSourceStack source, Collection<? extends Entity> targets, Holder<Enchantment> enchantment, int level, CallbackInfoReturnable<Integer> cir) {
        if (!((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        List<? extends Entity> entityList = List.copyOf(targets);
        HashSet categoriesApplied = Sets.newHashSet();
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            categoriesApplied.add(((ItemEnchantmentCategories)living.getMainHandItem().getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).findFirstCategory(enchantment));
        }
        Holder category = categoriesApplied.stream().filter(holder -> holder != null && holder.isBound()).max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.value()).priority())).orElse(null);
        if (category != null && !source.isSilent()) {
            HashSet hashSet = Sets.newHashSet();
            if (source.isPlayer() && source.getPlayer().acceptsSuccess()) {
                hashSet.add(source.getPlayer());
            }
            if (((Accessor_CommandSourceStack)source).enchiridion$getSource().shouldInformAdmins() && source.getServer().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
                hashSet.addAll(source.getServer().getPlayerList().getPlayers().stream().filter(serverPlayer -> serverPlayer != source.getPlayer() && source.getServer().getPlayerList().isOp(serverPlayer.getGameProfile())).toList());
            }
            for (ServerPlayer player : hashSet) {
                Enchiridion.getHelper().sendClientbound(player, new SendEnchantmentCategoryFromCommandClientboundPacket((Holder<EnchantmentCategory>)category));
            }
        }
    }
}

