/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.duck.Duck_LevelUpEnchantmentMenu;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantScrollIndexClientboundPacket;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.util.EnchantingTableUtil;
import house.greenhouse.enchiridion.util.EnchantmentComparisonUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EnchantingTableBlock;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentMenu.class})
public abstract class Mixin_EnchantmentMenu
extends AbstractContainerMenu
implements Duck_LevelUpEnchantmentMenu {
    @Unique
    private final DataSlot enchiridion$levelableEnchantmentSize = DataSlot.standalone();
    @Unique
    private final DataSlot enchiridion$bookshelfCount = DataSlot.standalone();
    @Unique
    private final int[] enchiridion$requiredBookshelves = new int[]{-1, -1, -1};
    @Unique
    private final List<Integer> enchiridion$allLevelUpCosts = new ArrayList<Integer>();
    @Unique
    private final List<Integer> enchiridion$allEnchantClues = new ArrayList<Integer>();
    @Unique
    private final List<Integer> enchiridion$allLevelClues = new ArrayList<Integer>();
    @Unique
    private final List<Integer> enchiridion$allRequiredBookshelves = new ArrayList<Integer>();
    @Shadow
    @Final
    public int[] costs;
    @Shadow
    @Final
    public int[] enchantClue;
    @Shadow
    @Final
    public int[] levelClue;
    @Shadow
    @Final
    private ContainerLevelAccess access;
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    private DataSlot enchantmentSeed;
    @Shadow
    @Final
    private Container enchantSlots;
    @Unique
    private double enchiridion$scrollOff = 0.0;
    @Unique
    private Player enchiridion$player;

    protected Mixin_EnchantmentMenu(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    private void enchiridion$addDataSlotsToEnchantingTableMenu(int containerId, Inventory inventory, ContainerLevelAccess level, CallbackInfo ci) {
        this.addDataSlot(this.enchiridion$levelableEnchantmentSize).set(-1);
        this.addDataSlot(this.enchiridion$bookshelfCount).set(-1);
        this.addDataSlot(DataSlot.shared((int[])this.enchiridion$requiredBookshelves, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.enchiridion$requiredBookshelves, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.enchiridion$requiredBookshelves, (int)2));
        this.enchiridion$player = inventory.player;
    }

    @ModifyReturnValue(method={"getEnchantmentList"}, at={@At(value="RETURN")})
    private List<EnchantmentInstance> enchiridion$modifyEnchantmentList(List<EnchantmentInstance> original, RegistryAccess registryAccess, ItemStack stack, int slot, int cost) {
        if (!((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().modifyEnchantingTableLogic()) {
            return original;
        }
        MutableObject mutable = new MutableObject();
        this.access.execute((arg_0, arg_1) -> this.lambda$enchiridion$modifyEnchantmentList$0(stack, slot, cost, (Mutable)mutable, arg_0, arg_1));
        if (mutable.getValue() != null) {
            return (List)mutable.getValue();
        }
        return original;
    }

    @Inject(method={"slotsChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z")}, cancellable=true)
    private void enchiridion$allowEnchantmentLevelUps(Container container, CallbackInfo ci, @Local ItemStack stack) {
        this.enchiridion$allLevelUpCosts.clear();
        this.enchiridion$allEnchantClues.clear();
        this.enchiridion$allLevelClues.clear();
        this.enchiridion$allRequiredBookshelves.clear();
        if (!stack.isEmpty() && EnchantmentHelper.hasAnyEnchantments((ItemStack)stack) && ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().allowEnchantingTableLevelUps()) {
            this.access.execute((level, blockPos) -> {
                int k;
                ArrayList<Object> enchantmentSet = new ArrayList(stack.getEnchantments().entrySet().stream().toList());
                if (enchantmentSet.isEmpty()) {
                    enchantmentSet = new ArrayList(((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet().stream().toList());
                }
                enchantmentSet = new ArrayList<Object2IntMap.Entry>(enchantmentSet.stream().filter(entry -> entry.getIntValue() < ((Enchantment)((Holder)entry.getKey()).value()).getMaxLevel()).toList());
                enchantmentSet.sort((o1, o2) -> EnchantmentComparisonUtil.compareEnchantments((Holder<Enchantment>)((Holder)o1.getKey()), (Holder<Enchantment>)((Holder)o2.getKey()), (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)));
                int i = 0;
                for (BlockPos blockPos2 : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
                    if (!EnchantingTableBlock.isValidBookShelf((Level)level, (BlockPos)blockPos, (BlockPos)blockPos2)) continue;
                    ++i;
                }
                int scrollOffset = Mth.floor((double)this.enchiridion$scrollOff);
                int size = enchantmentSet.size();
                if (scrollOffset > 0 && scrollOffset > size - 3) {
                    this.enchiridion$scrollOff = size - 3;
                    Player patt0$temp = this.enchiridion$player;
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                        Enchiridion.getHelper().sendClientbound(serverPlayer, new SyncEnchantScrollIndexClientboundPacket(Mth.floor((double)this.enchiridion$scrollOff)));
                    }
                }
                this.random.setSeed((long)this.enchantmentSeed.get());
                for (int j = 1; j < size; ++j) {
                    if (Enchiridion.getHelper().containsEnchantmentSeed(this.enchiridion$player, j)) continue;
                    int newSeed = level.random.nextInt();
                    Enchiridion.getHelper().addEnchantmentSeed(this.enchiridion$player, j - 1, newSeed);
                }
                for (k = 0; k < 3; ++k) {
                    this.costs[k] = 0;
                    this.enchantClue[k] = -1;
                    this.levelClue[k] = -1;
                    this.enchiridion$requiredBookshelves[k] = -1;
                }
                k = 0;
                for (int l = 0; l < enchantmentSet.size(); ++l) {
                    if (l > 0) {
                        this.random.setSeed((long)Enchiridion.getHelper().getEnchantmentSeed(this.enchiridion$player, l - 1));
                    }
                    Object2IntMap.Entry enchantment = (Object2IntMap.Entry)enchantmentSet.get(l);
                    int maxLevel = ((Enchantment)((Holder)enchantment.getKey()).value()).getMaxLevel();
                    int cost = EnchantingTableUtil.getLevelUpCost(enchantment.getIntValue() + 1, maxLevel);
                    int enchantClue = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getId((Object)((Enchantment)((Holder)enchantment.getKey()).value()));
                    int levelClue = enchantment.getIntValue() + 1;
                    int bookshelfCount = EnchantingTableUtil.getMinimumBookshelfAmountForLevelling(enchantment.getIntValue() + 1, maxLevel);
                    this.enchiridion$allLevelUpCosts.add(cost);
                    this.enchiridion$allEnchantClues.add(enchantClue);
                    this.enchiridion$allLevelClues.add(levelClue);
                    this.enchiridion$allRequiredBookshelves.add(bookshelfCount);
                    if (k >= 3 || l <= Mth.floor((double)this.enchiridion$scrollOff) - 1) continue;
                    this.costs[k] = cost;
                    this.enchantClue[k] = enchantClue;
                    this.levelClue[k] = levelClue;
                    this.enchiridion$requiredBookshelves[k] = bookshelfCount;
                    ++k;
                }
                this.enchiridion$bookshelfCount.set(i);
                this.enchiridion$levelableEnchantmentSize.set(size);
            });
            this.broadcastChanges();
            ci.cancel();
        } else {
            this.enchiridion$levelableEnchantmentSize.set(-1);
            this.enchiridion$bookshelfCount.set(-1);
            this.enchiridion$scrollOff = 0.0;
            Player player = this.enchiridion$player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Enchiridion.getHelper().sendClientbound(serverPlayer, new SyncEnchantScrollIndexClientboundPacket(0));
            }
            for (int j = 0; j < 3; ++j) {
                this.enchiridion$requiredBookshelves[j] = -1;
            }
        }
    }

    @ModifyVariable(method={"getEnchantmentList"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private int enchiridion$setEnchantmentLevelToFull(int original) {
        return Math.max(1, EnchantingTableUtil.getEnchantmentEffectiveness(original));
    }

    @ModifyVariable(method={"clickMenuButton"}, at=@At(value="LOAD"), ordinal=1)
    private int enchiridion$modifyLapisCountForLevelUps(int original, Player player, int index, @Local(ordinal=0) ItemStack stack) {
        Holder enchantment;
        if (!stack.isEmpty() && EnchantmentHelper.hasAnyEnchantments((ItemStack)stack) && ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().allowEnchantingTableLevelUps() && (enchantment = (Holder)player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap().byId(this.enchantClue[index])) != null && enchantment.isBound()) {
            return EnchantingTableUtil.getLapisCountForLevelling(this.levelClue[index], ((Enchantment)enchantment.value()).getMaxLevel());
        }
        return original;
    }

    @Inject(method={"clickMenuButton"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/ContainerLevelAccess;execute(Ljava/util/function/BiConsumer;)V")}, cancellable=true)
    private void enchiridion$performEnchantmentLevelUps(Player player, int index, CallbackInfoReturnable<Boolean> cir, @Local(ordinal=0) ItemStack stack, @Local(ordinal=1) ItemStack lapis, @Local(ordinal=1) int lapisCount) {
        if (!stack.isEmpty() && EnchantmentHelper.hasAnyEnchantments((ItemStack)stack) && ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().allowEnchantingTableLevelUps()) {
            this.access.execute((level, blockPos) -> {
                Holder enchantment = (Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap().byId(this.enchantClue[index]);
                if (enchantment != null && enchantment.isBound()) {
                    if ((double)index + this.enchiridion$scrollOff > 0.0) {
                        this.random.setSeed((long)Enchiridion.getHelper().getEnchantmentSeed(player, index + Mth.floor((double)this.enchiridion$scrollOff) - 1));
                    } else {
                        this.random.setSeed((long)this.enchantmentSeed.get());
                    }
                    stack.enchant(enchantment, this.levelClue[index]);
                    player.onEnchantmentPerformed(stack, EnchantingTableUtil.getLapisCountForLevelling(this.levelClue[index], ((Enchantment)enchantment.value()).getMaxLevel()));
                    lapis.consume(lapisCount, (LivingEntity)player);
                    if (lapis.isEmpty()) {
                        this.enchantSlots.setItem(1, ItemStack.EMPTY);
                    }
                    player.awardStat(Stats.ENCHANT_ITEM);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.ENCHANTED_ITEM.trigger(serverPlayer, stack, lapisCount);
                    }
                    this.enchantSlots.setChanged();
                    this.enchantmentSeed.set(player.getEnchantmentSeed());
                    this.slotsChanged(this.enchantSlots);
                    level.playSound(null, blockPos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                    this.broadcastChanges();
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
            });
        }
    }

    @Override
    public int enchiridion$getEnchantmentSize() {
        return this.enchiridion$levelableEnchantmentSize.get();
    }

    @Override
    public int enchiridion$getBookshelfCount() {
        return this.enchiridion$bookshelfCount.get();
    }

    @Override
    public int enchiridion$getRequiredBookshelves(int index) {
        return this.enchiridion$requiredBookshelves[index];
    }

    @Override
    public double enchiridion$getScrollOffset() {
        return this.enchiridion$scrollOff;
    }

    @Override
    public void enchiridion$setScrollOffset(double value) {
        this.enchiridion$scrollOff = value;
    }

    @Override
    public void enchiridion$refreshEnchantmentIndexes() {
        int scrollOff;
        for (int i = scrollOff = Mth.floor((double)this.enchiridion$scrollOff); i < 3 + scrollOff; ++i) {
            this.costs[i - scrollOff] = this.enchiridion$allLevelUpCosts.get(i);
            this.enchantClue[i - scrollOff] = this.enchiridion$allEnchantClues.get(i);
            this.levelClue[i - scrollOff] = this.enchiridion$allLevelClues.get(i);
            this.enchiridion$requiredBookshelves[i - scrollOff] = this.enchiridion$allRequiredBookshelves.get(i);
        }
    }

    private /* synthetic */ void lambda$enchiridion$modifyEnchantmentList$0(ItemStack stack, int slot, int cost, Mutable mutable, Level level, BlockPos pos) {
        List<EnchantmentInstance> enchantments = EnchantingTableUtil.getEnchantments(this.random, (LevelAccessor)level, pos, stack, slot, cost, this.enchantmentSeed.get());
        mutable.setValue(enchantments);
    }
}

