/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.effect.ItemResourceEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.util.ItemUtil;
import house.greenhouse.enchiridion.duck.Duck_EntityHeldItemStack;
import house.greenhouse.enchiridion.duck.Duck_ItemResource;
import house.greenhouse.enchiridion.duck.Duck_UseDuration;
import house.greenhouse.enchiridion.network.clientbound.SyncItemUseDurationClientboundPacket;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class Mixin_ItemStack
implements Duck_EntityHeldItemStack,
Duck_ItemResource,
Duck_UseDuration {
    @Unique
    private final Map<ResourceLocation, Boolean> enchiridion$stackResources = new HashMap<ResourceLocation, Boolean>();
    @Unique
    private WeakReference<Entity> enchiridion$holdingEntity = new WeakReference<Object>(null);
    @Unique
    private int enchiridion$itemUseDuration = Integer.MIN_VALUE;

    @Shadow
    public abstract boolean isEmpty();

    @Inject(method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V"}, at={@At(value="TAIL")})
    private void enchiridion$validateCategories(ItemLike item, int count, PatchedDataComponentMap components, CallbackInfo ci) {
        if (this.isEmpty()) {
            return;
        }
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            components.remove(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES);
        } else {
            ItemStack stack = (ItemStack)this;
            if (!components.has(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES)) {
                EnchantmentCategoryUtil.categoriseEnchantmentsOnItem(stack);
            }
            EnchantmentCategoryUtil.removeInvalidEnchantmentsFromItem(stack);
        }
    }

    @Inject(method={"inventoryTick"}, at={@At(value="TAIL")})
    private void enchiridion$tickChargeEffects(Level level, Entity entity, int inventorySlot, boolean isCurrentItem, CallbackInfo ci) {
        List<Object2IntMap.Entry> enchantments = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), (ItemStack)this).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ITEM_RESOURCE).isEmpty()).toList();
        if (!enchantments.isEmpty() && !level.isClientSide()) {
            for (Object2IntMap.Entry entry2 : enchantments) {
                List effects = ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.ITEM_RESOURCE);
                for (ItemResourceEffect effect : effects) {
                    if (this.enchiridion$stackResources.containsKey(effect.id())) continue;
                    this.enchiridion$stackResources.put(effect.id(), effect.defaultValue());
                }
            }
        }
    }

    @Override
    public Entity enchiridion$getEntity() {
        return (Entity)this.enchiridion$holdingEntity.get();
    }

    @Override
    public void enchiridion$setEntity(Entity entity) {
        this.enchiridion$holdingEntity = new WeakReference<Entity>(entity);
    }

    @Override
    public int enchiridion$getItemUseDuration() {
        return this.enchiridion$itemUseDuration;
    }

    @Override
    public void enchiridion$setItemUseDuration(int value) {
        this.enchiridion$itemUseDuration = value;
    }

    @Inject(method={"copy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setPopTime(I)V")})
    private void enchiridion$copyNewParams(CallbackInfoReturnable<ItemStack> cir, @Local(ordinal=1) ItemStack itemStack) {
        if (this.enchiridion$holdingEntity.get() != null) {
            ((Duck_EntityHeldItemStack)itemStack).enchiridion$setEntity((Entity)this.enchiridion$holdingEntity.get());
        }
    }

    @ModifyReturnValue(method={"getUseDuration"}, at={@At(value="RETURN")})
    private int enchiridion$modifyUseDuration(int original, @Local(argsOnly=true) LivingEntity entity) {
        Level level;
        boolean itemUseDurationInitialised;
        Mixin_ItemStack mixin_ItemStack;
        if (this.isEmpty() || !((mixin_ItemStack = this) instanceof ItemStack)) {
            return original;
        }
        ItemStack stack = (ItemStack)mixin_ItemStack;
        boolean bl = itemUseDurationInitialised = this.enchiridion$itemUseDuration != Integer.MIN_VALUE;
        if (!itemUseDurationInitialised) {
            this.enchiridion$itemUseDuration = original;
        }
        if ((level = entity.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            EquipmentSlot slot = entity.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            int newDuration = ItemUtil.modifyItemUseDuration(level2, (Entity)entity, slot, stack, original);
            if (this.enchiridion$itemUseDuration != newDuration) {
                Enchiridion.getHelper().sendClientboundTracking((Entity)entity, new SyncItemUseDurationClientboundPacket(entity.getId(), newDuration, stack));
            }
            this.enchiridion$itemUseDuration = newDuration;
        }
        return this.enchiridion$itemUseDuration;
    }

    @Override
    public boolean enchiridion$getResourceValue(ResourceLocation id) {
        return this.enchiridion$stackResources.getOrDefault(id, false);
    }

    @Override
    public void enchiridion$setResourceValue(ResourceLocation id, boolean value) {
        this.enchiridion$stackResources.put(id, value);
    }
}

