/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.AttributeTransferEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.RidingConditionalEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionAttributes;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParamSets;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParams;
import house.greenhouse.enchiridion.api.util.DamageUtil;
import house.greenhouse.enchiridion.api.util.ItemUtil;
import house.greenhouse.enchiridion.duck.Duck_AutoUse;
import house.greenhouse.enchiridion.duck.Duck_EntityRidingEffects;
import house.greenhouse.enchiridion.duck.Duck_PostEntityDropParams;
import house.greenhouse.enchiridion.util.EntityUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class Mixin_LivingEntity
extends Entity
implements Duck_AutoUse,
Duck_PostEntityDropParams {
    @Unique
    private static LootParams.Builder enchiridion$builder;
    @Shadow
    protected ItemStack useItem;
    @Shadow
    protected boolean jumping;
    @Unique
    private boolean enchiridion$autoUsing = false;
    @Unique
    private boolean enchiridion$originalOnClimbableResult = false;
    @Unique
    private int enchiridion$tickCountUntilAllowedToClimb = 0;
    @Unique
    private boolean enchiridion$groundState = false;
    @Unique
    private boolean enchiridion$canClimbInAir = false;
    @Unique
    private boolean enchiridion$jumpState = false;
    @Unique
    private double enchiridion$prevY = 0.0;

    public Mixin_LivingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract double getAttributeValue(Holder<Attribute> var1);

    @Shadow
    public abstract AttributeMap getAttributes();

    @Shadow
    public abstract boolean isFallFlying();

    @Shadow
    public abstract InteractionHand getUsedItemHand();

    @Shadow
    public abstract ItemStack getUseItem();

    @Shadow
    public abstract void stopUsingItem();

    @Shadow
    public abstract boolean onClimbable();

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private DamageSource enchiridion$changeDamageType(DamageSource source) {
        return DamageUtil.changeDamageType(source, (LivingEntity)this);
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;is(Lnet/minecraft/tags/TagKey;)Z", ordinal=4)})
    private boolean enchiridion$bypassCooldown(boolean original, @Local(argsOnly=true) DamageSource source) {
        return DamageUtil.bypassDamageCooldown(source, (LivingEntity)this);
    }

    @ModifyExpressionValue(method={"jumpFromGround"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getYRot()F")})
    private float enchiridion$modifyAddedJumpVelocityBasedOnDirection(float original) {
        LivingEntity thisAsLiving = (LivingEntity)this;
        if (Enchiridion.getHelper().hasSprintDirectionAttachment((Entity)thisAsLiving)) {
            Direction currentSprintingDirection = Enchiridion.getHelper().getCurrentSprintingDirection((Entity)thisAsLiving);
            if (currentSprintingDirection == Direction.NORTH) {
                return original;
            }
            if (currentSprintingDirection == Direction.SOUTH) {
                return original - 180.0f;
            }
            if (currentSprintingDirection == Direction.WEST) {
                return original - 90.0f;
            }
            if (currentSprintingDirection == Direction.EAST) {
                return original + 90.0f;
            }
        }
        return original;
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootTable;getRandomItems(Lnet/minecraft/world/level/storage/loot/LootParams;JLjava/util/function/Consumer;)V")})
    private void enchiridion$captureEntityDropBuilder(DamageSource source, boolean hasLastHurtByPlayer, CallbackInfo ci) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        enchiridion$builder = new LootParams.Builder(serverLevel);
        enchiridion$builder.withParameter(LootContextParams.THIS_ENTITY, (Object)this);
        enchiridion$builder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source);
        enchiridion$builder.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity());
        enchiridion$builder.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="TAIL")})
    private void enchiridion$resetEntityBuilder(DamageSource source, boolean hasLastHurtByPlayer, CallbackInfo ci) {
        enchiridion$builder = null;
    }

    @Override
    public LootParams.Builder enchiridion$getPostEntityDropsParams() {
        return enchiridion$builder;
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;canFreeze()Z", ordinal=0)})
    private boolean enchiridion$preventPowderSnowLogicIfEnchantmentFrozen(boolean original) {
        return original && !Enchiridion.getHelper().isFrozenByEnchantment(this);
    }

    @WrapWithCondition(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setTicksFrozen(I)V", ordinal=1)})
    private boolean enchiridion$preventUnfreezingIfEnchantmentFrozenAndInPowderSnow(LivingEntity instance, int i) {
        return !this.isInPowderSnow || !Enchiridion.getHelper().isFrozenByEnchantment((Entity)instance);
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;blockUsingShield(Lnet/minecraft/world/entity/LivingEntity;)V", shift=At.Shift.AFTER)})
    private void enchiridion$postShieldDisableActions(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity attacker;
        Entity entity = source.getDirectEntity();
        if (!(entity instanceof LivingEntity) || !(attacker = (LivingEntity)entity).canDisableShield() || this.level().isClientSide()) {
            return;
        }
        LootParams.Builder params = new LootParams.Builder((ServerLevel)this.level());
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)this);
        params.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source);
        params.withParameter(LootContextParams.ORIGIN, (Object)this.position());
        params.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity());
        params.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        for (Pair entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)attacker.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), attacker.getMainHandItem()).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(EquipmentSlot.MAINHAND) && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.POST_SHIELD_DISABLE).isEmpty()).map(entry -> Pair.of((Object)((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.POST_SHIELD_DISABLE), (Object)entry.getIntValue())).toList()) {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)((Integer)entry2.getSecond()));
            LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
            for (TargetedConditionalEffect effect : (List)entry2.getFirst()) {
                Mixin_LivingEntity entity2;
                if (!effect.matches(context)) continue;
                if ((entity2 = (switch (effect.affected()) {
                    default -> throw new MatchException(null, null);
                    case EnchantmentTarget.ATTACKER -> source.getEntity();
                    case EnchantmentTarget.DAMAGING_ENTITY -> source.getDirectEntity();
                    case EnchantmentTarget.VICTIM -> this;
                })) == null) continue;
                ((EnchantmentEntityEffect)effect.effect()).apply((ServerLevel)this.level(), ((Integer)entry2.getSecond()).intValue(), new EnchantedItemInUse(attacker.getMainHandItem(), EquipmentSlot.MAINHAND, attacker), (Entity)entity2, entity2.position());
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            for (Pair entry3 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), this.getItemBySlot(slot)).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot) && ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.POST_SHIELD_DISABLE).isEmpty()).map(entry -> Pair.of((Object)((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.POST_SHIELD_DISABLE), (Object)entry.getIntValue())).toList()) {
                params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)((Integer)entry3.getSecond()));
                LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_DAMAGE)).create(Optional.empty());
                for (TargetedConditionalEffect effect : (List)entry3.getFirst()) {
                    Mixin_LivingEntity entity3;
                    if (!effect.matches(context)) continue;
                    if ((entity3 = (switch (effect.affected()) {
                        default -> throw new MatchException(null, null);
                        case EnchantmentTarget.ATTACKER -> source.getEntity();
                        case EnchantmentTarget.DAMAGING_ENTITY -> source.getDirectEntity();
                        case EnchantmentTarget.VICTIM -> this;
                    })) == null) continue;
                    ((EnchantmentEntityEffect)effect.effect()).apply((ServerLevel)this.level(), ((Integer)entry3.getSecond()).intValue(), new EnchantedItemInUse(attacker.getItemBySlot(slot), slot, (LivingEntity)this), (Entity)entity3, entity3.position());
                }
            }
        }
    }

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeMap;")})
    private void enchiridion$changeVehicleEquipmentUponChange(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir, @Local EquipmentSlot slot, @Local(ordinal=0) ItemStack oldStack, @Local(ordinal=1) ItemStack newStack) {
        if (!this.level().isClientSide()) {
            LivingEntity thisAsLiving = (LivingEntity)this;
            ((Duck_EntityRidingEffects)((Object)this)).enchiridion$resetRidingEffects();
            AttributeTransferEffect.clearInvalidEffects(thisAsLiving, oldStack);
            if (this.getVehicle() != null) {
                ((Duck_EntityRidingEffects)((Object)this)).enchiridion$resetRidingEffects();
                LootParams.Builder params = new LootParams.Builder((ServerLevel)this.level());
                params.withParameter(LootContextParams.THIS_ENTITY, (Object)this);
                params.withParameter(EnchiridionLootContextParams.VEHICLE, (Object)this.getVehicle());
                params.withParameter(LootContextParams.ORIGIN, (Object)this.position());
                params.withOptionalParameter(EnchiridionLootContextParams.FIRST_PASSENGER, (Object)this.getFirstPassenger());
                for (Object2IntMap.Entry enchantment : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), newStack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot) && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.VEHICLE_CHANGED).isEmpty()).toList()) {
                    params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)enchantment.getIntValue());
                    for (RidingConditionalEffect conditionalEffect : ((Enchantment)((Holder)enchantment.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.VEHICLE_CHANGED)) {
                        if (!conditionalEffect.matches(new LootContext.Builder(params.create(EnchiridionLootContextParamSets.ENCHANTED_VEHICLE)).create(Optional.empty()))) {
                            return;
                        }
                        EnchantedItemInUse itemInUse = new EnchantedItemInUse(this.getItemBySlot(slot), slot, thisAsLiving);
                        for (Entity entity : conditionalEffect.affected().getEntities(this)) {
                            conditionalEffect.effect().onChangedBlock((ServerLevel)this.level(), enchantment.getIntValue(), itemInUse, entity, entity.position(), true);
                        }
                        ((Duck_EntityRidingEffects)((Object)this)).enchiridion$addRidingEffect(slot, enchantment.getIntValue(), conditionalEffect);
                    }
                }
            }
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;removeFrost()V")})
    private void enchiridion$removeEnchantmentFrost(CallbackInfo ci) {
        if (Enchiridion.getHelper().isFrozenByEnchantment(this) && this.getTicksFrozen() <= 0) {
            Enchiridion.getHelper().setFrozenByEnchantment(this, false);
        }
    }

    @ModifyExpressionValue(method={"tryAddFrost"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z")})
    private boolean enchiridion$allowSpeedDebuffWhenEnchantedFrost(boolean original) {
        return original && !Enchiridion.getHelper().isFrozenByEnchantment(this);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onGround()Z", ordinal=2))
    private float enchiridion$modifyFriction(float original) {
        return (float)((double)original * this.getAttributeValue(EnchiridionAttributes.FRICTION_MULTIPLIER));
    }

    @ModifyArg(method={"handleOnClimbable"}, at=@At(value="INVOKE", target="Ljava/lang/Math;max(DD)D"), index=1)
    private double enchiridion$modifyClimbingDownSpeed(double original) {
        double maxDownSpeed = original;
        double climbSpeed = this.getAttributeValue(EnchiridionAttributes.CLIMB_SPEED) - 0.2;
        return maxDownSpeed -= climbSpeed * 0.66 - 0.05;
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onGround()Z")})
    private boolean enchiridion$extendJumpTime(boolean original) {
        return original || Enchiridion.getHelper().getAirTime(this) > -1 && Enchiridion.getHelper().getAirTime(this) < (int)(this.getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0);
    }

    @ModifyExpressionValue(method={"getFrictionInfluencedSpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onGround()Z")})
    private boolean enchiridion$useGroundFricitonSpeed(boolean original) {
        return original || Enchiridion.getHelper().getAirTime(this) > -1 && Enchiridion.getHelper().getAirTime(this) < (int)(this.getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0);
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onGround()Z", ordinal=2)})
    private boolean enchiridion$useGroundFrictionMultiplier(boolean original) {
        return original || Enchiridion.getHelper().getAirTime(this) > -1 && Enchiridion.getHelper().getAirTime(this) < (int)(this.getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0);
    }

    @ModifyArg(method={"jumpFromGround"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private Vec3 enchiridion$modifySprintJumpVelocity(Vec3 vec3) {
        return vec3.multiply(this.getAttributeValue(EnchiridionAttributes.SPRINT_JUMP_VELOCITY_MULTIPLIER), 0.0, this.getAttributeValue(EnchiridionAttributes.SPRINT_JUMP_VELOCITY_MULTIPLIER));
    }

    @ModifyArg(method={"handleRelativeFrictionAndCalculateMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;handleOnClimbable(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 enchiridion$setAirTimeAndStayInAir(Vec3 vec3) {
        if (this.getAttributes().hasAttribute(EnchiridionAttributes.JUMP_EXTENSION_TIME) && EntityUtil.isNotInsideBlocks(this) && this.fluidHeight.object2DoubleEntrySet().stream().noneMatch(entry -> entry.getDoubleValue() > 0.0)) {
            if (this.getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) > 0.0) {
                boolean longFall;
                if (Enchiridion.getHelper().getAirTime(this) < (int)(this.getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0) && (vec3.y > 0.0 || this.onClimbable() || this.isFallFlying() || this.isCrouching())) {
                    Enchiridion.getHelper().setAirTime(this, (int)(this.getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0));
                }
                if (!this.level().getBlockState(this.getOnPos()).getCollisionShape((BlockGetter)this.level(), this.getOnPos(), CollisionContext.of((Entity)this)).isEmpty() && Enchiridion.getHelper().getAirTime(this) > 0) {
                    Enchiridion.getHelper().setAirTime(this, 0);
                }
                boolean bl = longFall = this.level().clip(new ClipContext(this.position(), this.position().add(0.0, -0.4, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
                if (longFall && Enchiridion.getHelper().getAirTime(this) < (int)(this.getAttributeValue(EnchiridionAttributes.JUMP_EXTENSION_TIME) * 20.0)) {
                    Enchiridion.getHelper().setAirTime(this, Enchiridion.getHelper().getAirTime(this) + 1);
                    return vec3.multiply(1.0, 0.0, 1.0);
                }
            } else if (Enchiridion.getHelper().getAirTime(this) != -1) {
                Enchiridion.getHelper().setAirTime(this, -1);
            }
        }
        if (this.onGround() || this.enchiridion$originalOnClimbableResult) {
            if (this.getAttributeValue(EnchiridionAttributes.CLIMB_TIME) > 0.0) {
                Enchiridion.getHelper().setClimbTime(this, Mth.floor((double)(this.getAttributeValue(EnchiridionAttributes.CLIMB_TIME) * 20.0)));
            } else if (Enchiridion.getHelper().getClimbTime(this) != -1) {
                Enchiridion.getHelper().setClimbTime(this, -1);
            }
        } else if (this.getAttributeValue(EnchiridionAttributes.CLIMB_TIME) < 0.04) {
            Enchiridion.getHelper().setClimbTime(this, 0);
        }
        return vec3;
    }

    @Override
    public boolean enchiridion$isAutoUsing() {
        return this.enchiridion$autoUsing;
    }

    @Override
    public void enchiridion$setAutoUsing(boolean value) {
        this.enchiridion$autoUsing = value;
    }

    @Inject(method={"releaseUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void enchiridion$preventItemUseRelease(CallbackInfo ci) {
        if (this.level().isClientSide()) {
            return;
        }
        LivingEntity thisAsLiving = (LivingEntity)this;
        if (!this.useItem.isEmpty() && ItemUtil.preventsPostItemUse((ServerLevel)this.level(), this.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, this.getUseItem(), thisAsLiving) && !this.enchiridion$isAutoUsing()) {
            this.stopUsingItem();
            ci.cancel();
        }
    }

    @Inject(method={"stopUsingItem"}, at={@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack;EMPTY:Lnet/minecraft/world/item/ItemStack;")})
    private void enchiridion$clearUseAmount(CallbackInfo ci) {
        if (!this.level().isClientSide()) {
            LivingEntity thisAsLiving = (LivingEntity)this;
            if (this.enchiridion$isAutoUsing()) {
                Enchiridion.getHelper().setUseAmount((Entity)thisAsLiving, Enchiridion.getHelper().getUseAmount((Entity)thisAsLiving) + 1);
                this.enchiridion$setAutoUsing(false);
                return;
            }
            Enchiridion.getHelper().setUseAmount((Entity)thisAsLiving, 0);
            this.getUseItem().getUseDuration((LivingEntity)this);
        }
    }

    @ModifyExpressionValue(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isUsingItem()Z", ordinal=1)})
    private boolean enchiridion$preventItemUseFinish(boolean original) {
        if (this.level().isClientSide()) {
            return original;
        }
        boolean preventsItemUse = ItemUtil.preventsPostItemUse((ServerLevel)this.level(), this.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, this.getUseItem(), (LivingEntity)this);
        boolean autoUsing = this.enchiridion$isAutoUsing();
        if (preventsItemUse && !autoUsing) {
            this.stopUsingItem();
        }
        return original && (!preventsItemUse || autoUsing);
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;")})
    private void enchiridion$setStateUponJumping(CallbackInfo ci) {
        this.enchiridion$jumpState = true;
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V"), index=1)
    private double enchiridion$modifyClimbingSpeedInWater(double original) {
        if (Enchiridion.getHelper().getClimbTime(this) == 0) {
            return 0.0;
        }
        return original + (this.getAttributeValue(EnchiridionAttributes.CLIMB_SPEED) - 0.2);
    }

    @ModifyArg(method={"handleRelativeFrictionAndCalculateMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V"), index=1)
    private double enchiridion$modifyClimbingSpeed(double original) {
        if (Enchiridion.getHelper().getClimbTime(this) == 0) {
            return 0.0;
        }
        return original + (this.getAttributeValue(EnchiridionAttributes.CLIMB_SPEED) - 0.2);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void enchiridion$depleteClimbTime(CallbackInfo ci) {
        boolean movingUpLadder;
        boolean bl = this.level().isClientSide() ? this.horizontalCollision || this.jumping : (movingUpLadder = this.enchiridion$prevY < this.getY());
        if (this.onClimbable() && !this.enchiridion$originalOnClimbableResult && movingUpLadder && Enchiridion.getHelper().getClimbTime(this) > 0) {
            Enchiridion.getHelper().setClimbTime(this, Math.max(Enchiridion.getHelper().getClimbTime(this) - 1, 0));
        }
        if (!this.level().isClientSide()) {
            this.enchiridion$prevY = this.getY();
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void enchiridion$modifyPositionStates(CallbackInfo ci) {
        if (this.onGround() || this.onClimbable()) {
            this.enchiridion$jumpState = false;
        }
        if (this.enchiridion$groundState) {
            if (this.enchiridion$jumpState || !this.onClimbable() && (double)this.fallDistance > 0.07) {
                this.enchiridion$groundState = false;
                this.enchiridion$canClimbInAir = false;
                BlockPos pos = new BlockPos(this.blockPosition().getX(), Mth.floor((double)this.getY(1.0)), this.blockPosition().getZ());
                this.enchiridion$tickCountUntilAllowedToClimb = this.tickCount + (this.enchiridion$jumpState || this.level().getBlockState(pos.above()).getCollisionShape((BlockGetter)this.level(), pos.above(), CollisionContext.of((Entity)this)).isEmpty() ? 3 : 12);
            } else if (!this.onGround()) {
                this.enchiridion$groundState = false;
            }
        } else if (this.onGround() && !this.horizontalCollision) {
            this.enchiridion$groundState = true;
            this.enchiridion$canClimbInAir = true;
            this.enchiridion$jumpState = false;
            this.enchiridion$tickCountUntilAllowedToClimb = Integer.MIN_VALUE;
        }
    }

    @ModifyReturnValue(method={"onClimbable"}, at={@At(value="RETURN")})
    private boolean enchiridion$allowClimbingAnyBlock(boolean original) {
        this.enchiridion$originalOnClimbableResult = original;
        if (!this.enchiridion$canClimbInAir && this.enchiridion$tickCountUntilAllowedToClimb < this.tickCount) {
            this.enchiridion$canClimbInAir = true;
        }
        if (original) {
            return true;
        }
        if (this.getAttributeValue(EnchiridionAttributes.CLIMB_TIME) < (double)0.001f || (!this.onGround() || !this.horizontalCollision) && !this.enchiridion$canClimbInAir) {
            return false;
        }
        BlockCollisions blockCollisions = new BlockCollisions((CollisionGetter)this.level(), (Entity)this, this.getBoundingBox().inflate(0.06, 0.02, 0.06), false, (pos, shape) -> Pair.of((Object)pos.immutable(), (Object)shape));
        while (blockCollisions.hasNext()) {
            Pair pair = (Pair)blockCollisions.next();
            if (this.onGround() && this.getOnPos().getY() == ((BlockPos)pair.getFirst()).getY() || this.blockPosition().getY() + Mth.ceil((double)(this.getBoundingBox().maxY - this.getBoundingBox().minY)) == ((BlockPos)pair.getFirst()).getY() || ((VoxelShape)pair.getSecond()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"startUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;gameEvent(Lnet/minecraft/core/Holder;)V")})
    private void enchiridion$onStartUsingItem(InteractionHand hand, CallbackInfo ci) {
        if (!this.level().isClientSide) {
            ItemUtil.onUseItem((ServerLevel)this.level(), (LivingEntity)this, this.getUseItem(), hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
    }

    @WrapOperation(method={"getDamageAfterMagicAbsorb"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterMagicAbsorb(FF)F")})
    private float enchiridion$modifyMagicAbsorbDamage(float damage, float enchantModifiers, Operation<Float> original, @Local(argsOnly=true) DamageSource source) {
        return DamageUtil.modifyProtectionDamage(source, damage, enchantModifiers, (xva$0, xva$1) -> ((Float)original.call(new Object[]{xva$0, xva$1})).floatValue(), (LivingEntity)this);
    }
}

