/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin.client;

import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.ConditionalSidedEnchantmentEntityEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.network.serverbound.AttackEnchantmentEffectServerboundEnchantmentPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class Mixin_Minecraft {
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public ClientLevel level;

    @Inject(method={"startAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;")})
    private void enchiridion$onAttackMiss(CallbackInfoReturnable<Boolean> cir) {
        if (this.hitResult == null || this.hitResult.getType() == HitResult.Type.BLOCK || this.player == null) {
            return;
        }
        DataComponentType<List<ConditionalSidedEnchantmentEntityEffect>> componentType = this.hitResult.getType() != HitResult.Type.MISS ? EnchiridionEnchantmentEffectComponents.HIT_ATTACK : EnchiridionEnchantmentEffectComponents.MISSED_ATTACK;
        ConditionalSidedEnchantmentEntityEffect.clientApply(componentType, (Entity)this.player, new EnchantedItemInUse(this.player.getWeaponItem(), EquipmentSlot.MAINHAND, (LivingEntity)this.player), (Level)this.level, this.hitResult.getLocation());
        ConditionalSidedEnchantmentEntityEffect.removeAllOfType(componentType, (Entity)this.player);
        Enchiridion.getHelper().sendServerbound(new AttackEnchantmentEffectServerboundEnchantmentPacket(this.hitResult.getLocation(), this.hitResult.getType() != HitResult.Type.MISS));
    }
}

