/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.neoforge.client.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import house.greenhouse.enchiridion.Enchiridion;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.PackRepository;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

public class EnchiridionDefaultEnabledResourcePacks {
    public static void reloadPacks(List<String> enabledPacks) {
        Path packCache = FMLPaths.GAMEDIR.get().resolve("enchiridion_resource_pack_cache.json");
        if (!packCache.toFile().exists()) {
            EnchiridionDefaultEnabledResourcePacks.updateResourcePackCache(enabledPacks, packCache);
        } else {
            try {
                JsonElement element = JsonParser.parseReader((Reader)new FileReader(packCache.toFile()));
                if (element.isJsonArray()) {
                    List<String> resPacksToApply = EnchiridionDefaultEnabledResourcePacks.resPacksToApply(element.getAsJsonArray());
                    if (resPacksToApply.isEmpty()) {
                        return;
                    }
                    EnchiridionDefaultEnabledResourcePacks.updateResourcePackCache(enabledPacks, packCache, resPacksToApply, element.getAsJsonArray());
                } else {
                    Enchiridion.LOG.warn("Enchiridion resource pack cache is not a JSON Array. Resetting values...");
                    EnchiridionDefaultEnabledResourcePacks.updateResourcePackCache(enabledPacks, packCache);
                }
            }
            catch (IOException ex) {
                Enchiridion.LOG.error("Failed to create resource pack cache for Enchiridion.", (Throwable)ex);
            }
        }
    }

    private static List<String> resPacksToApply(JsonArray jsonArray) {
        PackRepository repository = Minecraft.getInstance().getResourcePackRepository();
        return repository.getAvailablePacks().stream().filter(s -> s.getId().startsWith("mod/enchiridion:") && s.getPackSource().shouldAddAutomatically() && !s.isRequired()).map(s -> s.getId().substring(4)).filter(s -> !jsonArray.contains((JsonElement)new JsonPrimitive(s))).toList();
    }

    private static void updateResourcePackCache(List<String> enabledPacks, Path packCache) {
        ArrayList<String> resPacksToApply = new ArrayList<String>();
        resPacksToApply.add(Enchiridion.id("resourcepacks/enchanted_books").toString());
        if (Enchiridion.ENCHANTMENT_DESCRIPTION_MODS.stream().anyMatch(s -> FMLLoader.getLoadingModList().getModFileById(s) != null)) {
            resPacksToApply.add(Enchiridion.id("resourcepacks/enchantment_descriptions_compat").toString());
        }
        if (!resPacksToApply.isEmpty()) {
            EnchiridionDefaultEnabledResourcePacks.updateResourcePackCache(enabledPacks, packCache, resPacksToApply, new JsonArray());
        }
    }

    private static void updateResourcePackCache(List<String> enabledPacks, Path packCache, List<String> resPacksToApply, JsonArray element) {
        for (String resPack : resPacksToApply) {
            enabledPacks.add("mod/" + resPack);
        }
        try {
            if (!Files.exists(packCache, new LinkOption[0])) {
                Files.createFile(packCache, new FileAttribute[0]);
            }
            try (FileWriter fileWriter = new FileWriter(packCache.toFile());
                 JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);){
                jsonWriter.beginArray();
                for (JsonElement innerElement : element.asList()) {
                    if (!innerElement.isJsonPrimitive() || !innerElement.getAsJsonPrimitive().isString()) continue;
                    jsonWriter.value(innerElement.getAsJsonPrimitive().getAsString());
                }
                for (String resPack : resPacksToApply) {
                    jsonWriter.value(resPack);
                }
                jsonWriter.endArray();
            }
        }
        catch (IOException ex) {
            Enchiridion.LOG.error("Failed to create resource pack cache for Enchiridion. Resetting values...", (Throwable)ex);
            EnchiridionDefaultEnabledResourcePacks.updateResourcePackCache(enabledPacks, packCache);
        }
    }
}

