/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.neoforge.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.RunFunctionOnLootEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParamSets;
import house.greenhouse.enchiridion.mixin.Accessor_LootParams;
import house.greenhouse.enchiridion.neoforge.mixin.Accessor_LootContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class RunEnchantedBlockFunctionsLootModifier
extends LootModifier {
    public static final MapCodec<RunEnchantedBlockFunctionsLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions)).apply((Applicative)inst, RunEnchantedBlockFunctionsLootModifier::new));

    public RunEnchantedBlockFunctionsLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Registry registry = context.getLevel().getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE);
        Optional lootTable = registry.getHolder(context.getQueriedLootTableId());
        if (lootTable.isEmpty()) {
            return generatedLoot;
        }
        LootParams.Builder paramBuilder = new LootParams.Builder(context.getLevel());
        for (Map.Entry<LootContextParam<?>, Object> param : ((Accessor_LootParams)((Accessor_LootContext)context).enchiridion$getParams()).enchiridion$getParams().entrySet()) {
            paramBuilder.withParameter(param.getKey(), param.getValue());
        }
        if (context.hasParam(LootContextParams.TOOL)) {
            EquipmentSlot slot = EquipmentSlot.MAINHAND;
            for (Map.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)context.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), (ItemStack)context.getParam(LootContextParams.TOOL)).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.RUN_FUNCTIONS_ON_BLOCK_LOOT).isEmpty() && (!context.hasParam(LootContextParams.THIS_ENTITY) || ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot))).toList()) {
                paramBuilder.withOptionalParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)((Integer)entry2.getValue()));
                LootParams params2 = paramBuilder.create(EnchiridionLootContextParamSets.ENCHANTED_BLOCK);
                LootContext blockContext = new LootContext.Builder(params2).create(Optional.empty());
                for (ConditionalEffect effect : ((Enchantment)((Holder)entry2.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.RUN_FUNCTIONS_ON_BLOCK_LOOT)) {
                    boolean matches = ((RunFunctionOnLootEffect)effect.effect()).lootTables().isEmpty() || ((RunFunctionOnLootEffect)effect.effect()).lootTables().map(either -> (Boolean)either.map(tableTagKey -> registry.getTag(tableTagKey).map(holders -> holders.contains((Holder)lootTable.get())).orElse(false), resourceKeys -> resourceKeys.stream().anyMatch(arg_0 -> ((Holder.Reference)((Holder.Reference)lootTable.get())).is(arg_0)))).orElse(false) != false;
                    if (!matches || !effect.matches(blockContext)) continue;
                    RunFunctionOnLootEffect.modifyLoot((RunFunctionOnLootEffect)effect.effect(), generatedLoot, blockContext, (Holder<LootTable>)((Holder)lootTable.get()));
                }
            }
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

