/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.neoforge.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record LootTableTagCondition(TagKey<LootTable> tag) implements LootItemCondition
{
    public static final MapCodec<LootTableTagCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)TagKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("tag").forGetter(LootTableTagCondition::tag)).apply((Applicative)inst, LootTableTagCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public boolean test(LootContext context) {
        Registry lootTableRegistry = context.getLevel().getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE);
        return lootTableRegistry.getTag(this.tag).map(holders -> holders).orElse(HolderSet.empty()).contains((Holder)lootTableRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)context.getQueriedLootTableId())));
    }

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }
}

