/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.neoforge.platform;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.api.enchantment.effect.DirectionalSprintEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.SidedEnchantmentEntityEffectInstance;
import house.greenhouse.enchiridion.block.entity.SiphoningTableBlockEntity;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.neoforge.EnchiridionNeoForge;
import house.greenhouse.enchiridion.neoforge.mixin.Accessor_ChunkMap;
import house.greenhouse.enchiridion.neoforge.mixin.Accessor_EntityTracker;
import house.greenhouse.enchiridion.neoforge.registry.EnchiridionAttachments;
import house.greenhouse.enchiridion.neoforge.registry.EnchiridionDataMaps;
import house.greenhouse.enchiridion.network.clientbound.SyncEnchantmentLevelUpSeedsClientboundPacket;
import house.greenhouse.enchiridion.platform.EnchiridionPlatformHelper;
import house.greenhouse.enchiridion.platform.Platform;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class EnchiridionPlatformHelperNeoForge
implements EnchiridionPlatformHelper {
    @Override
    public Platform getPlatform() {
        return Platform.NEOFORGE;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public RegistryAccess getReqistryAccess() {
        return EnchiridionNeoForge.getRegistryAccess();
    }

    @Override
    public ItemEnchantments getEnchantments(HolderLookup.RegistryLookup<Enchantment> enchantments, ItemStack stack) {
        return stack.getAllEnchantments(enchantments);
    }

    @Override
    public void openMenu(Player player, SiphoningTableBlockEntity blockEntity, BlockPos pos) {
        player.openMenu((MenuProvider)blockEntity, pos);
    }

    @Override
    public Collection<ServerPlayer> getTracking(Entity entity) {
        ChunkMap chunkLoadingManager;
        Accessor_EntityTracker tracker;
        ChunkSource source = entity.level().getChunkSource();
        if (source instanceof ServerChunkCache && (tracker = (Accessor_EntityTracker)((Accessor_ChunkMap)(chunkLoadingManager = ((ServerChunkCache)source).chunkMap)).getEntityMap().get(entity.getId())) != null) {
            return tracker.getSeenBy().stream().map(ServerPlayerConnection::getPlayer).collect(Collectors.toUnmodifiableSet());
        }
        return Collections.emptySet();
    }

    @Override
    public MenuType<SiphoningMenu> createMenuType() {
        return IMenuTypeExtension.create((id, inventory, buf) -> new SiphoningMenu(id, inventory, buf.readBlockPos()));
    }

    @Override
    public void sendClientbound(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendClientboundTracking(Entity entity, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendServerbound(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setFrozenByEnchantment(Entity entity, boolean value) {
        if (value) {
            entity.setData(EnchiridionAttachments.FROZEN_BY_ENCHANTMENT, (Object)true);
        }
        entity.removeData(EnchiridionAttachments.FROZEN_BY_ENCHANTMENT);
    }

    @Override
    public int getAirTime(Entity entity) {
        return entity.getExistingData(EnchiridionAttachments.AIR_TIME).orElse(-1);
    }

    @Override
    public void setAirTime(Entity entity, int value) {
        if (value == -1) {
            entity.removeData(EnchiridionAttachments.AIR_TIME);
        }
        entity.setData(EnchiridionAttachments.AIR_TIME, (Object)value);
    }

    @Override
    public int getClimbTime(Entity entity) {
        return entity.getExistingData(EnchiridionAttachments.CLIMB_TIME).orElse(-1);
    }

    @Override
    public void setClimbTime(Entity entity, int value) {
        if (value == -1) {
            entity.removeData(EnchiridionAttachments.CLIMB_TIME);
        }
        entity.setData(EnchiridionAttachments.CLIMB_TIME, (Object)value);
    }

    @Override
    public Map<DataComponentType<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>> getClientEntityEffectComponents(Entity entity) {
        return (Map)entity.getExistingData(EnchiridionAttachments.CLIENT_ENTITY_EFFECT_COMPONENTS).orElse(new Object2ObjectArrayMap());
    }

    @Override
    public List<Pair<SidedEnchantmentEntityEffectInstance, Integer>> getClientEntityEffectComponents(Entity entity, DataComponentType<?> enchantmentComponent) {
        return entity.getExistingData(EnchiridionAttachments.CLIENT_ENTITY_EFFECT_COMPONENTS).orElse(Collections.emptyMap()).getOrDefault(enchantmentComponent, List.of());
    }

    @Override
    public void setClientEntityEffectComponents(Entity entity, Map<DataComponentType<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>> effects) {
        if (effects.isEmpty()) {
            entity.removeData(EnchiridionAttachments.CLIENT_ENTITY_EFFECT_COMPONENTS);
            return;
        }
        entity.setData(EnchiridionAttachments.CLIENT_ENTITY_EFFECT_COMPONENTS, effects);
    }

    @Override
    public int getUseAmount(Entity entity) {
        return entity.getExistingData(EnchiridionAttachments.USE_AMOUNT).orElse(0);
    }

    @Override
    public void setUseAmount(Entity entity, int value) {
        if (value < 1) {
            entity.removeData(EnchiridionAttachments.USE_AMOUNT);
            return;
        }
        entity.setData(EnchiridionAttachments.USE_AMOUNT, (Object)value);
    }

    @Override
    public boolean containsEnchantmentSeed(Player player, int index) {
        return player.getExistingData(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS).orElse(List.of()).size() < index;
    }

    @Override
    public int getEnchantmentSeed(Player player, int index) {
        return player.getExistingData(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS).map(integers -> (Integer)integers.get(index)).orElse(-1);
    }

    @Override
    public void addEnchantmentSeed(Player player, int index, int seed) {
        ((List)player.getData(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS)).add(index, seed);
        if (!player.level().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)SyncEnchantmentLevelUpSeedsClientboundPacket.add(player.getId(), index, seed), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void clearEnchantmentSeeds(Player player) {
        player.removeData(EnchiridionAttachments.ENCHANTMENT_LEVEL_UP_SEEDS);
    }

    @Override
    public boolean isFrozenByEnchantment(Entity entity) {
        return entity.getExistingData(EnchiridionAttachments.FROZEN_BY_ENCHANTMENT).orElse(false);
    }

    @Override
    public boolean hasSprintDirectionAttachment(Entity entity) {
        return entity.hasData(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS);
    }

    @Override
    public void setAbleToSprintInDirection(Entity entity, List<Direction> directions) {
        entity.setData(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS, directions);
    }

    @Override
    public void removeSprintDirections(Entity entity) {
        entity.removeData(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS);
    }

    @Override
    public boolean canSprintInDirection(Entity entity, Direction direction) {
        return entity.getExistingData(EnchiridionAttachments.ALLOWED_SPRINT_DIRECTIONS).orElse(DirectionalSprintEffect.DEFAULT).contains(direction);
    }

    @Override
    public Direction getCurrentSprintingDirection(Entity entity) {
        return entity.getExistingData(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION).orElse(null);
    }

    @Override
    public boolean hasCurrentSprintingDirection(Entity entity) {
        return entity.hasData(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION);
    }

    @Override
    public void setCurrentSprintingDirection(Entity entity, @Nullable Direction direction) {
        if (direction == null) {
            entity.removeData(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION);
            return;
        }
        entity.setData(EnchiridionAttachments.CURRENT_SPRINTING_DIRECTION, (Object)direction);
    }

    @Override
    public UUID getPreviousAttackTarget(Entity entity) {
        return entity.getExistingData(EnchiridionAttachments.PREVIOUS_ATTACK_TARGET).orElse(null);
    }

    @Override
    public void setPreviousAttacKTarget(Entity entity, Entity target) {
        entity.setData(EnchiridionAttachments.PREVIOUS_ATTACK_TARGET, (Object)target.getUUID());
    }

    @Override
    public boolean isClient() {
        return EffectiveSide.get().isClient();
    }

    @Override
    public boolean isPrimaryItem(ItemStack stack, Holder<Enchantment> enchantment) {
        return stack.isPrimaryItemFor(enchantment);
    }

    @Override
    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return stack.supportsEnchantment(enchantment);
    }

    @Override
    @Nullable
    public ItemStack getItemForSplittingEnchantment(Holder<Item> item) {
        return (ItemStack)item.getData(EnchiridionDataMaps.SPLITTING);
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getSkullLootTableForEntity(Holder<EntityType<?>> entityType) {
        return (ResourceKey)entityType.getData(EnchiridionDataMaps.SKULLS);
    }

    @Override
    public ItemStack getAttachmentWeaponStack(Entity entity) {
        return entity.getExistingData(EnchiridionAttachments.WEAPON).orElse(ItemStack.EMPTY);
    }

    @Override
    public void setAttachmentWeaponStack(Entity entity, ItemStack stack) {
        entity.setData(EnchiridionAttachments.WEAPON, (Object)stack);
    }
}

