/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.network.clientbound;

import house.greenhouse.enchiridion.Enchiridion;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record SyncEnchantedFrozenStateClientboundPacket(int entityId, boolean value) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Enchiridion.id("sync_enchanted_frozen_state");
    public static final CustomPacketPayload.Type<SyncEnchantedFrozenStateClientboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, SyncEnchantedFrozenStateClientboundPacket> STREAM_CODEC = CustomPacketPayload.codec(SyncEnchantedFrozenStateClientboundPacket::write, SyncEnchantedFrozenStateClientboundPacket::new);

    public SyncEnchantedFrozenStateClientboundPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.value);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            if (Minecraft.getInstance().level == null) {
                return;
            }
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
            Enchiridion.getHelper().setFrozenByEnchantment(entity, this.value);
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

