/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.network.serverbound;

import com.mojang.serialization.Codec;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.ConditionalSidedEnchantmentEntityEffect;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.util.WeaponUtil;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record AttackEnchantmentEffectServerboundEnchantmentPacket(Vec3 hitTarget, boolean hit) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Enchiridion.id("attack_enchantment_effect");
    public static final CustomPacketPayload.Type<AttackEnchantmentEffectServerboundEnchantmentPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, AttackEnchantmentEffectServerboundEnchantmentPacket> STREAM_CODEC = CustomPacketPayload.codec(AttackEnchantmentEffectServerboundEnchantmentPacket::write, AttackEnchantmentEffectServerboundEnchantmentPacket::new);

    public AttackEnchantmentEffectServerboundEnchantmentPacket(FriendlyByteBuf buf) {
        this((Vec3)ByteBufCodecs.fromCodec((Codec)Vec3.CODEC).decode((Object)buf), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        ByteBufCodecs.fromCodec((Codec)Vec3.CODEC).encode((Object)buf, (Object)this.hitTarget);
        buf.writeBoolean(this.hit);
    }

    public void handle(ServerPlayer player) {
        if (player.getServer() == null) {
            return;
        }
        player.getServer().execute(() -> {
            if (this.hit) {
                WeaponUtil.runHitAttackEffects((LivingEntity)player, this.hitTarget);
            } else {
                WeaponUtil.runMissedAttackEffects((LivingEntity)player, this.hitTarget);
            }
            DataComponentType<List<ConditionalSidedEnchantmentEntityEffect>> componentType = this.hit ? EnchiridionEnchantmentEffectComponents.HIT_ATTACK : EnchiridionEnchantmentEffectComponents.MISSED_ATTACK;
            ConditionalSidedEnchantmentEntityEffect.removeAllOfType(componentType, (Entity)player);
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

