/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.recipe;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.menu.SiphoningInput;
import house.greenhouse.enchiridion.mixin.Invoker_EnchantmentHelper;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import house.greenhouse.enchiridion.util.SiphoningBookCategory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiphoningRecipe
implements Recipe<SiphoningInput> {
    private final String group;
    private final SiphoningBookCategory category;
    private final NonNullList<Ingredient> ingredients;
    private final IntList ingredientCosts;
    private final Map<Holder<EnchantmentCategory>, ItemEnchantments> enchantments;
    private final int experienceCost;
    private final int time;
    private List<IngredientWithAmount> ingredientsWithAmounts;

    public SiphoningRecipe(@Nullable String group, SiphoningBookCategory category, List<IngredientWithAmount> ingredients, Map<Holder<EnchantmentCategory>, ItemEnchantments> enchantments, int experienceCost, int time) {
        this(group, category, SiphoningRecipe.createIngredientList(ingredients), SiphoningRecipe.createAmountList(ingredients), enchantments, experienceCost, time);
    }

    protected SiphoningRecipe(@Nullable String group, SiphoningBookCategory category, List<Ingredient> ingredients, List<Integer> ingredientCosts, Map<Holder<EnchantmentCategory>, ItemEnchantments> enchantments, int experienceCost, int time) {
        this(group, category, SiphoningRecipe.transformIngredientList(ingredients), (IntList)new IntArrayList(ingredientCosts), enchantments, experienceCost, time);
    }

    protected SiphoningRecipe(@Nullable String group, SiphoningBookCategory category, NonNullList<Ingredient> ingredients, IntList ingredientCosts, Map<Holder<EnchantmentCategory>, ItemEnchantments> enchantments, int experienceCost, int time) {
        if (ingredients.size() > 2 || ingredientCosts.size() > 2) {
            throw new IllegalArgumentException("SiphoningRecipe does not support more than two ingredients.");
        }
        if (ingredients.size() != ingredientCosts.size()) {
            throw new IllegalArgumentException("SiphoningRecipe's ingredient and cost list are not the same size.");
        }
        this.group = group;
        this.category = category;
        this.ingredients = ingredients;
        this.ingredientCosts = ingredientCosts;
        this.experienceCost = experienceCost;
        this.enchantments = enchantments;
        this.time = time;
    }

    public static NonNullList<Ingredient> createIngredientList(List<IngredientWithAmount> ingredients) {
        NonNullList list = NonNullList.withSize((int)2, (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            list.set(i, (Object)ingredients.get(i).ingredient());
        }
        return list;
    }

    public static NonNullList<Ingredient> transformIngredientList(List<Ingredient> ingredients) {
        NonNullList list = NonNullList.withSize((int)2, (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredients.size(); ++i) {
            list.set(i, (Object)ingredients.get(i));
        }
        return list;
    }

    public static IntList createAmountList(List<IngredientWithAmount> ingredients) {
        return new IntArrayList(ingredients.stream().map(IngredientWithAmount::amount).toList());
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public SiphoningBookCategory getCategory() {
        return this.category;
    }

    public List<IngredientWithAmount> getIngredientsWithAmounts() {
        if (this.ingredientsWithAmounts == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < Math.min(this.ingredients.size(), this.ingredientCosts.size()); ++i) {
                builder.add((Object)new IngredientWithAmount((Ingredient)this.ingredients.get(i), this.ingredientCosts.getInt(i)));
            }
            this.ingredientsWithAmounts = builder.build();
        }
        return this.ingredientsWithAmounts;
    }

    public boolean matches(SiphoningInput input, @NotNull Level level) {
        ItemStack ingredientOne = input.getItem(0);
        ItemStack ingredientTwo = input.getItem(1);
        ItemStack enchantable = input.getItem(2);
        if (ingredientOne.getCount() < (Integer)this.ingredientCosts.getFirst() || !((Ingredient)this.ingredients.getFirst()).test(ingredientOne)) {
            return false;
        }
        if (ingredientTwo.getCount() < (Integer)this.ingredientCosts.getLast() || !((Ingredient)this.ingredients.getLast()).test(ingredientTwo)) {
            return false;
        }
        if (enchantable.is(EnchiridionTags.ItemTags.STORED_ENCHANTABLES)) {
            return true;
        }
        List supportedItems = this.getEnchantments().entrySet().stream().flatMap(entry -> ((ItemEnchantments)entry.getValue()).entrySet().stream().flatMap(entry1 -> ((Enchantment)((Holder)entry1.getKey()).value()).getSupportedItems().stream().filter(itemHolder -> this.getEnchantments().values().stream().allMatch(enchantments -> enchantments.keySet().stream().allMatch(enchantment -> ((Enchantment)enchantment.value()).isSupportedItem(((Item)itemHolder.value()).getDefaultInstance())))))).toList();
        if (supportedItems.isEmpty()) {
            return false;
        }
        return this.getEnchantments().entrySet().stream().allMatch(entry -> {
            ItemEnchantmentCategories categories = (ItemEnchantmentCategories)enchantable.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            if (((ItemEnchantments)entry.getValue()).keySet().size() + categories.get((Holder<EnchantmentCategory>)((Holder)entry.getKey())).size() < ((EnchantmentCategory)((Holder)entry.getKey()).value()).limit().orElse(Integer.MIN_VALUE)) {
                return false;
            }
            return ((ItemEnchantments)entry.getValue()).entrySet().stream().allMatch(entry1 -> ((Enchantment)((Holder)entry1.getKey()).value()).isSupportedItem(enchantable));
        }) && supportedItems.contains(enchantable.getItemHolder());
    }

    @NotNull
    public ItemStack assemble(SiphoningInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ItemStack stack = input.getItem(2).is(Items.BOOK) ? new ItemStack((Holder)Items.ENCHANTED_BOOK.builtInRegistryHolder(), 1, input.getItem(2).getComponentsPatch()) : input.getItem(2).copy();
        return this.assemble(stack.copyWithCount(1), registries);
    }

    private ItemStack assemble(ItemStack stack, HolderLookup.Provider registries) {
        if (!stack.is(EnchiridionTags.ItemTags.STORED_ENCHANTABLES) && this.enchantments.values().stream().anyMatch(holder -> holder.entrySet().stream().anyMatch(entry -> !Enchiridion.getHelper().supportsEnchantment(stack, (Holder<Enchantment>)((Holder)entry.getKey()))))) {
            return stack;
        }
        EnchantmentCategoryUtil.updateCategories(stack, categories -> EnchantmentHelper.updateEnchantments((ItemStack)stack, enchantments -> {
            for (Map.Entry<Holder<EnchantmentCategory>, ItemEnchantments> entry : this.enchantments.entrySet()) {
                for (Object2IntMap.Entry enchantment : entry.getValue().entrySet()) {
                    if (!((Holder)enchantment.getKey()).isBound() || !categories.toImmutable().isValid(entry.getKey(), (Holder<Enchantment>)((Holder)enchantment.getKey())) || !((Enchantment)((Holder)enchantment.getKey()).value()).isSupportedItem(stack) && Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack) != DataComponents.STORED_ENCHANTMENTS) {
                        return;
                    }
                    categories.add(entry.getKey(), (Holder<Enchantment>)((Holder)enchantment.getKey()));
                    enchantments.upgrade((Holder)enchantment.getKey(), enchantment.getIntValue());
                }
            }
        }));
        return stack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > this.ingredients.size();
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ItemStack stack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentCategoryUtil.updateCategories(stack, categories -> EnchantmentHelper.updateEnchantments((ItemStack)stack, enchantments -> {
            for (Map.Entry<Holder<EnchantmentCategory>, ItemEnchantments> entry : this.enchantments.entrySet()) {
                for (Object2IntMap.Entry enchantment : entry.getValue().entrySet()) {
                    if (!((Holder)enchantment.getKey()).isBound() || !categories.toImmutable().isValid(entry.getKey(), (Holder<Enchantment>)((Holder)enchantment.getKey())) || !((Enchantment)((Holder)enchantment.getKey()).value()).isSupportedItem(stack) && Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack) != DataComponents.STORED_ENCHANTMENTS) {
                        return;
                    }
                    categories.add(entry.getKey(), (Holder<Enchantment>)((Holder)enchantment.getKey()));
                    enchantments.upgrade((Holder)enchantment.getKey(), enchantment.getIntValue());
                }
            }
        }));
        return stack;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public List<Integer> getIngredientCosts() {
        return this.ingredientCosts;
    }

    public Map<Holder<EnchantmentCategory>, ItemEnchantments> getEnchantments() {
        return this.enchantments;
    }

    public int getExperienceCost() {
        return this.experienceCost;
    }

    public int getTime() {
        return this.time;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return EnchiridionRecipeTypes.SIPHONING;
    }

    public record IngredientWithAmount(Ingredient ingredient, int amount) {
        public static final Codec<IngredientWithAmount> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(IngredientWithAmount::ingredient), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(IngredientWithAmount::amount)).apply((Applicative)inst, IngredientWithAmount::new));
        public static final Codec<IngredientWithAmount> CODEC = Codec.withAlternative(DIRECT_CODEC, (Codec)Ingredient.CODEC_NONEMPTY, in -> new IngredientWithAmount((Ingredient)in, 1));
        public static final StreamCodec<RegistryFriendlyByteBuf, IngredientWithAmount> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, IngredientWithAmount::ingredient, (StreamCodec)ByteBufCodecs.INT, IngredientWithAmount::amount, IngredientWithAmount::new);
    }

    public static class Serializer
    implements RecipeSerializer<SiphoningRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<SiphoningRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SiphoningRecipe::getGroup), (App)SiphoningBookCategory.CODEC.fieldOf("category").orElse((Object)SiphoningBookCategory.MISC).forGetter(SiphoningRecipe::getCategory), (App)Codec.list(IngredientWithAmount.CODEC, (int)1, (int)2).fieldOf("ingredients").forGetter(SiphoningRecipe::getIngredientsWithAmounts), (App)Codec.unboundedMap(EnchantmentCategory.CODEC, (Codec)ItemEnchantments.CODEC).fieldOf("enchantments").forGetter(SiphoningRecipe::getEnchantments), (App)Codec.INT.optionalFieldOf("experience_cost", (Object)5).forGetter(SiphoningRecipe::getExperienceCost), (App)Codec.INT.optionalFieldOf("time", (Object)4800).forGetter(SiphoningRecipe::getTime)).apply((Applicative)inst, SiphoningRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SiphoningRecipe> STREAM_CODEC = StreamCodec.of(Serializer::encode, Serializer::decode);

        protected Serializer() {
        }

        private static void encode(RegistryFriendlyByteBuf buf, SiphoningRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeEnum((Enum)recipe.category);
            IngredientWithAmount.STREAM_CODEC.apply(ByteBufCodecs.list((int)2)).encode((Object)buf, recipe.getIngredientsWithAmounts());
            ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.holderRegistry(EnchiridionRegistries.ENCHANTMENT_CATEGORY), (StreamCodec)ItemEnchantments.STREAM_CODEC).encode((Object)buf, new HashMap<Holder<EnchantmentCategory>, ItemEnchantments>(recipe.enchantments));
            buf.writeInt(recipe.experienceCost);
            buf.writeInt(recipe.time);
        }

        public static SiphoningRecipe decode(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            SiphoningBookCategory category = (SiphoningBookCategory)buf.readEnum(SiphoningBookCategory.class);
            List ingredients = (List)IngredientWithAmount.STREAM_CODEC.apply(ByteBufCodecs.list((int)2)).decode((Object)buf);
            Map enchantments = (Map)ByteBufCodecs.map(HashMap::new, EnchantmentCategory.STREAM_CODEC, (StreamCodec)ItemEnchantments.STREAM_CODEC).decode((Object)buf);
            int experienceCost = buf.readInt();
            int time = buf.readInt();
            return new SiphoningRecipe(group, category, ingredients, enchantments, experienceCost, time);
        }

        @NotNull
        public MapCodec<SiphoningRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SiphoningRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

