/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import house.greenhouse.enchiridion.util.EnchantmentComparisonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class CreativeTabUtil {
    public static void addSiphoningTableToCreativeMenu(InsertionConsumer consumer) {
        consumer.insert(Items.ENCHANTING_TABLE.getDefaultInstance(), EnchiridionItems.SIPHONING_TABLE.getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public static void sortEnchantmentsBasedOnCategory(List<ItemStack> stacks, Consumer<List<ItemStack>> addConsumer, HolderLookup.Provider provider) {
        if (stacks.stream().allMatch(stack -> EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).isEmpty())) {
            return;
        }
        ArrayList<Pair> indexList = new ArrayList<Pair>(IntStream.range(0, stacks.size()).mapToObj(i -> Pair.of((Object)i, (Object)((ItemStack)stacks.get(i)))).toList());
        List<Item> itemList = indexList.stream().map(pair -> ((ItemStack)pair.getSecond()).getItem()).toList();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(indexList.stream().map(Pair::getSecond).toList());
        stackList.sort((o1, o2) -> {
            ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)o1);
            ItemEnchantments enchantments2 = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)o2);
            ItemEnchantmentCategories categories = (ItemEnchantmentCategories)o1.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            ItemEnchantmentCategories categories2 = (ItemEnchantmentCategories)o2.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            if (o1.getItem() != o2.getItem() || enchantments.isEmpty() || enchantments2.isEmpty()) {
                return Integer.compare(itemList.indexOf(o1.getItem()), itemList.indexOf(o2.getItem()));
            }
            Pair<Holder<Enchantment>, Integer> enchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(provider, enchantments, categories);
            Pair<Holder<Enchantment>, Integer> enchantment2 = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(provider, enchantments2, categories2);
            int o1CategoryPriority = Optional.ofNullable(EnchantmentCategoryUtil.getFirstEnchantmentCategory(provider, enchantments, categories)).map(category -> {
                if (!category.isBound()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.value()).priority();
            }).orElse(0);
            int o2CategoryPriority = Optional.ofNullable(EnchantmentCategoryUtil.getFirstEnchantmentCategory(provider, enchantments2, categories2)).map(category -> {
                if (!category.isBound()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.value()).priority();
            }).orElse(0);
            if (enchantment != null && enchantment2 != null && ((Holder)enchantment.getFirst()).equals(enchantment2.getFirst())) {
                return Integer.compare((Integer)enchantment.getSecond(), (Integer)enchantment2.getSecond());
            }
            if (o1CategoryPriority == o2CategoryPriority && enchantment != null && enchantment2 != null) {
                return EnchantmentComparisonUtil.compareEnchantmentNames((Holder<Enchantment>)((Holder)enchantment.getFirst()), (Holder<Enchantment>)((Holder)enchantment2.getFirst()));
            }
            return Integer.compare(o2CategoryPriority, o1CategoryPriority);
        });
        addConsumer.accept(stackList);
    }

    public static interface InsertionConsumer {
        public void insert(ItemStack var1, ItemStack var2, CreativeModeTab.TabVisibility var3);
    }
}

