/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.mixin.Invoker_EnchantmentHelper;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchantmentCategoryUtil {
    public static ItemEnchantmentCategories updateCategories(ItemStack stack, Consumer<ItemEnchantmentCategories.Mutable> consumer) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            consumer.accept(new ItemEnchantmentCategories.Mutable(ItemEnchantmentCategories.EMPTY));
            return ItemEnchantmentCategories.EMPTY;
        }
        return (ItemEnchantmentCategories)stack.update(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY, categories -> {
            ItemEnchantmentCategories.Mutable mutable = new ItemEnchantmentCategories.Mutable((ItemEnchantmentCategories)categories);
            consumer.accept(mutable);
            return mutable.toImmutable();
        });
    }

    public static void enchantFromCategory(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> enchantments, Holder<EnchantmentCategory> category) {
        EnchantmentCategoryUtil.enchantFromCategories(random, stack, level, enchantments, List.of(category));
    }

    public static void enchantFromCategories(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> enchantments, List<Holder<EnchantmentCategory>> categories) {
        EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)stack, (int)level, Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories() ? enchantments : enchantments.filter(enchantmentHolder -> categories.stream().anyMatch(holder -> holder.isBound() && ((EnchantmentCategory)holder.value()).acceptedEnchantments().contains(enchantmentHolder))));
    }

    public static void categoriseEnchantmentsOnItem(ItemStack stack) {
        DataComponentType<ItemEnchantments> enchantmentComponent = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        EnchantmentCategoryUtil.categoriseEnchantmentsOnItem((ItemEnchantments)stack.getOrDefault(enchantmentComponent, (Object)ItemEnchantments.EMPTY), stack, enchantmentComponent);
    }

    public static void categoriseEnchantmentsOnItem(ItemEnchantments enchantments, ItemStack stack, DataComponentType<ItemEnchantments> componentType) {
        if (enchantments.isEmpty() || Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        if (componentType == DataComponents.STORED_ENCHANTMENTS) {
            EnchantmentCategoryUtil.categoriseStoredEnchantmentsOnItem(enchantments, stack);
            return;
        }
        EnchantmentCategoryUtil.updateCategories(stack, mutable -> enchantments.keySet().forEach(enchantment -> {
            Holder<EnchantmentCategory> category = EnchantmentCategoryUtil.getFirstEnchantmentCategory((HolderLookup.Provider)Enchiridion.getHelper().getReqistryAccess(), (Holder<Enchantment>)enchantment);
            if (category == null) {
                return;
            }
            if (!category.isBound() || mutable.contains((Holder<Enchantment>)enchantment) && mutable.contains(category, (Holder<Enchantment>)enchantment) || !EnchantmentCategoryUtil.categoryAcceptsNewEnchantments(category, mutable.toImmutable())) {
                return;
            }
            mutable.add(category, (Holder<Enchantment>)enchantment);
        }));
    }

    public static void removeInvalidEnchantmentsFromItem(ItemStack stack) {
        DataComponentType<ItemEnchantments> enchantmentComponent = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        if (((ItemEnchantments)stack.getOrDefault(enchantmentComponent, (Object)ItemEnchantments.EMPTY)).isEmpty() || Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        DataComponentType<ItemEnchantments> enchantmentsComponentType = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        stack.update(enchantmentsComponentType, (Object)ItemEnchantments.EMPTY, itemEnchantments -> {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
            mutable.removeIf(enchantmentHolder -> !((ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).contains((Holder<Enchantment>)enchantmentHolder));
            return mutable.toImmutable();
        });
    }

    private static void categoriseStoredEnchantmentsOnItem(ItemEnchantments enchantments, ItemStack stack) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        HashMap usedEnchantmentTags = new HashMap();
        EnchantmentCategoryUtil.updateCategories(stack, categories -> enchantments.keySet().forEach(enchantment -> {
            block1: {
                List<Holder> applicableCategories = EnchantmentCategoryUtil.getAllEnchantmentCategories((HolderLookup.Provider)Enchiridion.getHelper().getReqistryAccess(), (Holder<Enchantment>)enchantment).stream().sorted(Comparator.comparingInt(value -> ((EnchantmentCategory)value.value()).priority())).toList();
                Iterator<Holder> iterator = applicableCategories.iterator();
                if (!iterator.hasNext()) break block1;
                Holder category = iterator.next();
                HolderSet tag = ((Enchantment)enchantment.value()).definition().primaryItems().orElse(((Enchantment)enchantment.value()).definition().supportedItems());
                if (!category.isBound() || categories.contains((Holder<Enchantment>)enchantment) && categories.contains((Holder<EnchantmentCategory>)category, (Holder<Enchantment>)enchantment) || usedEnchantmentTags.containsKey(category) && ((Set)usedEnchantmentTags.get(category)).stream().anyMatch(holders -> holders.stream().anyMatch(arg_0 -> ((HolderSet)tag).contains(arg_0)))) {
                    return;
                }
                categories.add((Holder<EnchantmentCategory>)category, (Holder<Enchantment>)enchantment);
                usedEnchantmentTags.computeIfAbsent(category, c -> new HashSet()).add(tag);
            }
        }));
    }

    @Nullable
    public static Pair<Holder<Enchantment>, Integer> getFirstEnchantmentAndLevel(HolderLookup.Provider registries, ItemEnchantments enchantments, ItemEnchantmentCategories categories) {
        Optional tooltipOrderTag = registries.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.TOOLTIP_ORDER);
        Optional<Pair> enchantment = Stream.concat(tooltipOrderTag.map(holders -> holders.stream()).orElse(Stream.empty()), registries.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(e -> tooltipOrderTag == null || !((HolderSet.Named)tooltipOrderTag.get()).contains((Holder)e))).filter(holder -> enchantments.keySet().contains(holder)).sorted((o1, o2) -> {
            Holder<EnchantmentCategory> firstCategory = categories.findFirstCategory((Holder<Enchantment>)o1);
            Holder<EnchantmentCategory> secondCategory = categories.findFirstCategory((Holder<Enchantment>)o2);
            int firstCategoryPriority = firstCategory != null ? ((EnchantmentCategory)firstCategory.value()).priority() : 0;
            int secondCategoryPriority = secondCategory != null ? ((EnchantmentCategory)secondCategory.value()).priority() : 0;
            return Integer.compare(secondCategoryPriority, firstCategoryPriority);
        }).findFirst().map(holder -> Pair.of((Object)holder, (Object)enchantments.getLevel(holder)));
        return enchantment.orElse(null);
    }

    @Nullable
    public static Holder<EnchantmentCategory> getFirstEnchantmentCategory(HolderLookup.Provider registries, ItemEnchantments enchantments, ItemEnchantmentCategories categories) {
        if (enchantments.isEmpty()) {
            return null;
        }
        Pair<Holder<Enchantment>, Integer> enchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(registries, enchantments, categories);
        return Optional.ofNullable(enchantment).map(pair -> categories.findFirstCategory((Holder<Enchantment>)((Holder)pair.getFirst()))).filter(holder -> holder != null && holder.isBound()).orElse(null);
    }

    public static Holder<EnchantmentCategory> getFirstEnchantmentCategory(HolderLookup.Provider registries, Holder<Enchantment> enchantment) {
        return registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).listElements().filter(category -> category.isBound() && ((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)).max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.value()).priority())).orElse(null);
    }

    public static List<Holder<EnchantmentCategory>> getAllEnchantmentCategories(HolderLookup.Provider registries, Holder<Enchantment> enchantment) {
        if (!((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return Collections.emptyList();
        }
        return registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).listElements().filter(category -> category.isBound() && ((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)).collect(Collectors.toList());
    }

    public static boolean isValidInCategory(HolderLookup.Provider registries, ItemEnchantmentCategories categories, Holder<Enchantment> enchantment) {
        Optional<Holder.Reference> category = registries.lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).listElements().filter(c -> c.isBound() && ((EnchantmentCategory)c.value()).acceptedEnchantments().contains(enchantment)).max(Comparator.comparingInt(o -> ((EnchantmentCategory)o.value()).priority()));
        return category.map(enchantmentCategory -> EnchantmentCategoryUtil.isValidInCategory((Holder<EnchantmentCategory>)enchantmentCategory, categories.get((Holder<EnchantmentCategory>)enchantmentCategory), enchantment)).orElse(true);
    }

    public static boolean isValidInCategory(Holder<EnchantmentCategory> category, List<Holder<Enchantment>> enchantments, Holder<Enchantment> enchantment) {
        if (!(enchantments = new ArrayList<Holder<Enchantment>>(enchantments)).contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return category.isBound() && (((EnchantmentCategory)category.value()).limit().isEmpty() || enchantments.subList(0, enchantments.indexOf(enchantment)).size() < ((EnchantmentCategory)category.value()).limit().get());
    }

    public static boolean categoryAcceptsNewEnchantments(Holder<EnchantmentCategory> category, ItemEnchantmentCategories categories) {
        if (!category.isBound() || ((EnchantmentCategory)category.value()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        return EnchantmentCategoryUtil.categoryAcceptsNewEnchantmentsInternal(category, List.copyOf((Collection)categories.getCategories().get(category)));
    }

    public static boolean categoryAcceptsNewEnchantmentsWithValue(Holder<EnchantmentCategory> category, ItemEnchantmentCategories categories, Holder<Enchantment> enchantment) {
        if (!category.isBound() || ((EnchantmentCategory)category.value()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        ArrayList<Holder<Enchantment>> enchantments = new ArrayList<Holder<Enchantment>>((Collection)categories.getCategories().get(category));
        if (!enchantments.contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return EnchantmentCategoryUtil.categoryAcceptsNewEnchantmentsInternal(category, enchantments);
    }

    private static boolean categoryAcceptsNewEnchantmentsInternal(Holder<EnchantmentCategory> category, List<Holder<Enchantment>> holders) {
        return category.isBound() && (((EnchantmentCategory)category.value()).limit().isEmpty() || holders.size() <= ((EnchantmentCategory)category.value()).limit().get());
    }
}

