/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentComparisonUtil {
    public static int compareEnchantments(Holder<Enchantment> enchantment, Holder<Enchantment> enchantment2, ItemEnchantmentCategories categories) {
        int o2CategoryPriority;
        if (!enchantment.isBound() && !enchantment2.isBound()) {
            return 0;
        }
        if (!enchantment.isBound() && enchantment2.isBound()) {
            return -1;
        }
        if (enchantment.isBound() && !enchantment2.isBound()) {
            return 1;
        }
        int o1CategoryPriority = Optional.ofNullable(categories.findFirstCategory(enchantment)).map(category -> {
            if (!category.isBound()) {
                return Integer.MIN_VALUE;
            }
            return ((EnchantmentCategory)category.value()).priority();
        }).orElse(0);
        if (o1CategoryPriority == (o2CategoryPriority = Optional.ofNullable(categories.findFirstCategory(enchantment2)).map(category -> {
            if (!category.isBound()) {
                return Integer.MIN_VALUE;
            }
            return ((EnchantmentCategory)category.value()).priority();
        }).orElse(0).intValue())) {
            return EnchantmentComparisonUtil.compareEnchantmentNames(enchantment, enchantment2);
        }
        return Integer.compare(o2CategoryPriority, o1CategoryPriority);
    }

    public static int compareEnchantmentNames(Holder<Enchantment> enchantment, Holder<Enchantment> enchantment2) {
        if (enchantment.unwrapKey().isPresent() && ((ResourceKey)enchantment.unwrapKey().get()).location().getNamespace().equals("minecraft") && enchantment2.unwrapKey().isPresent() && !((ResourceKey)enchantment2.unwrapKey().get()).location().getNamespace().equals("minecraft")) {
            return -1;
        }
        if (enchantment.unwrapKey().isPresent() && !((ResourceKey)enchantment.unwrapKey().get()).location().getNamespace().equals("minecraft") && enchantment2.unwrapKey().isPresent() && ((ResourceKey)enchantment2.unwrapKey().get()).location().getNamespace().equals("minecraft")) {
            return 1;
        }
        if (enchantment.unwrapKey().isPresent() && enchantment2.unwrapKey().isPresent()) {
            return ((ResourceKey)enchantment.unwrapKey().get()).location().compareTo(((ResourceKey)enchantment2.unwrapKey().get()).location());
        }
        return Integer.compare(enchantment.hashCode(), enchantment2.hashCode());
    }
}

