/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.CategoryVisuals;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.mixin.Accessor_ItemEnchantments;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentCategories;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;

public class TextUtil {
    public static final ResourceLocation FABRIC_EVENT_PHASE = Enchiridion.id("enchantment_tooltip_modifications");

    public static void modifyEnchantmentTooltips(ItemStack stack, Item.TooltipContext tooltipContext, TooltipFlag flag, List<Component> components) {
        if (tooltipContext.registries() == null || !stack.isEnchanted() && !stack.has(DataComponents.STORED_ENCHANTMENTS) || stack.get(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES) == null) {
            return;
        }
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.getOrDefault(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
        ArrayList enchantmentComponents = new ArrayList();
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        if (enchantments.isEmpty() || !((Accessor_ItemEnchantments)enchantments).enchiridion$shouldShowInTooltip()) {
            return;
        }
        enchantments.addToTooltip(tooltipContext, enchantmentComponents::add, flag);
        enchantmentComponents.sort((o1, o2) -> {
            Optional o1Enchantment = tooltipContext.registries().lookupOrThrow(Registries.ENCHANTMENT).filterElements(e -> o1.contains(e.description())).listElements().findFirst();
            Optional o2Enchantment = tooltipContext.registries().lookupOrThrow(Registries.ENCHANTMENT).filterElements(e -> o2.contains(e.description())).listElements().findFirst();
            if (o1Enchantment.isEmpty() || o2Enchantment.isEmpty()) {
                return Integer.compare(components.indexOf(o1), components.indexOf(o2));
            }
            Holder<EnchantmentCategory> category = categories.findFirstCategory((Holder<Enchantment>)((Holder)o1Enchantment.get()));
            Holder<EnchantmentCategory> category2 = categories.findFirstCategory((Holder<Enchantment>)((Holder)o2Enchantment.get()));
            int categoryPriority = 0;
            int category2Priority = 0;
            if (category != null && category.isBound()) {
                categoryPriority = ((EnchantmentCategory)category.value()).priority();
            }
            if (category2 != null && category2.isBound()) {
                category2Priority = ((EnchantmentCategory)category2.value()).priority();
            }
            return Integer.compare(category2Priority, categoryPriority);
        });
        boolean shouldDisplayCategories = TextUtil.shouldDisplayCategories();
        ArrayList<Component> originalComponents = new ArrayList<Component>(components);
        int processed = -1;
        int enchantmentEndIndex = -1;
        boolean descriptionsEnabled = false;
        HashMap<Holder.Reference, Integer> categoriesToProcess = new HashMap<Holder.Reference, Integer>();
        block0: for (int i = 0; i < enchantmentComponents.size(); ++i) {
            Component component = (Component)enchantmentComponents.get(i);
            Optional enchantment = tooltipContext.registries().lookupOrThrow(Registries.ENCHANTMENT).filterElements(e -> component.contains(e.description())).listElements().findFirst();
            if (enchantment.isEmpty()) continue;
            for (int j = 0; j < originalComponents.size(); ++j) {
                Component toReplace = (Component)originalComponents.get(j);
                if (enchantmentComponents.stream().noneMatch(comp -> comp.equals((Object)toReplace)) || processed >= j) continue;
                processed = j;
                Holder.Reference category = categories.findFirstCategory((Holder<Enchantment>)((Holder)enchantment.get()));
                if (category == null) {
                    category = Minecraft.getInstance().level.registryAccess().lookupOrThrow(EnchiridionRegistries.ENCHANTMENT_CATEGORY).getOrThrow(EnchiridionEnchantmentCategories.UNCATEGORISED);
                }
                Holder.Reference finalCategory = category;
                MutableComponent newComp = component.copy();
                if (category.isBound()) {
                    Style style = component.getStyle();
                    style = style.withColor(((EnchiridionConfig)Enchiridion.CONFIG.get()).client().getBookVisuals((Holder<EnchantmentCategory>)finalCategory).map(CategoryVisuals::textColor).orElseGet(() -> TextUtil.lambda$modifyEnchantmentTooltips$5((Holder)finalCategory)));
                    newComp = newComp.copy().withStyle(style);
                }
                enchantmentEndIndex = j + 1;
                if (descriptionsEnabled || originalComponents.stream().anyMatch(TextUtil::isEnchantmentDescription)) {
                    int index = -1;
                    for (int k = 0; k < originalComponents.size(); ++k) {
                        if (!((Component)originalComponents.get(k)).equals((Object)component)) continue;
                        index = k;
                        break;
                    }
                    if (index != -1) {
                        components.set(j + 1, (Component)originalComponents.get(index + 1));
                        ++enchantmentEndIndex;
                        descriptionsEnabled = true;
                    }
                }
                if (shouldDisplayCategories && !categoriesToProcess.containsKey(finalCategory)) {
                    categoriesToProcess.put(finalCategory, j + categoriesToProcess.size());
                }
                components.set(j, (Component)newComp);
                continue block0;
            }
        }
        if (enchantmentEndIndex > -1 && !shouldDisplayCategories && !TextUtil.hasDisplayTooltip(components)) {
            MutableComponent component = TextUtil.getKeybindHint();
            if (component != null) {
                components.add(enchantmentEndIndex, (Component)component.withStyle(ChatFormatting.DARK_GRAY));
            }
        } else {
            int first = categoriesToProcess.values().stream().min(Comparator.comparingInt(value -> value)).orElse(-1);
            if (first == -1) {
                return;
            }
            for (Map.Entry entry : categoriesToProcess.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).toList()) {
                Holder category = (Holder)entry.getKey();
                Style style = Style.EMPTY.withColor(ChatFormatting.GRAY);
                style = style.withColor(((EnchiridionConfig)Enchiridion.CONFIG.get()).client().getBookVisuals((Holder<EnchantmentCategory>)category).map(CategoryVisuals::textColor).orElseGet(() -> ((EnchantmentCategory)category.value()).visuals().textColor()));
                components.add((Integer)entry.getValue(), (Component)((EnchantmentCategory)category.value()).name().copy().withStyle(style));
                ++enchantmentEndIndex;
            }
            originalComponents = new ArrayList<Component>(components);
            for (int i = first; i < enchantmentEndIndex; ++i) {
                if (categoriesToProcess.containsValue(i)) continue;
                components.set(i, (Component)Component.literal((String)"   ").append((Component)originalComponents.get(i)));
            }
        }
    }

    private static boolean shouldDisplayCategories() {
        if (Enchiridion.getHelper().isModLoaded("item-descriptions") && ModHelpers.useInternalEnchantmentDescriptions()) {
            return ((Boolean)ModClient.CONFIG.keybinds.displayWhenCtrlIsHeld.value() != false && Screen.hasControlDown() || (Boolean)ModClient.CONFIG.keybinds.displayWhenAltIsHeld.value() != false && Screen.hasAltDown() || (Boolean)ModClient.CONFIG.keybinds.displayWhenShiftIsHeld.value() != false && Screen.hasShiftDown()) ^ (Boolean)ModClient.CONFIG.keybinds.invert.value();
        }
        return Screen.hasShiftDown();
    }

    @NotNull
    private static MutableComponent getKeybindHint() {
        MutableComponent keybind = Component.translatable((String)"key.keyboard.shift");
        if (Enchiridion.getHelper().isModLoaded("item-descriptions") && ModHelpers.useInternalEnchantmentDescriptions()) {
            keybind = Component.literal((String)"");
            boolean ctrl = (Boolean)ModClient.CONFIG.keybinds.displayWhenCtrlIsHeld.value();
            boolean alt = (Boolean)ModClient.CONFIG.keybinds.displayWhenAltIsHeld.value();
            boolean shift = (Boolean)ModClient.CONFIG.keybinds.displayWhenShiftIsHeld.value();
            if (ctrl) {
                keybind = keybind.append((Component)Component.translatable((String)"key.keyboard.control"));
                if (alt || shift) {
                    keybind.append("/");
                }
            }
            if (alt) {
                keybind.append((Component)Component.translatable((String)"key.keyboard.alt"));
                if (shift) {
                    keybind.append("/");
                }
            }
            if (shift) {
                keybind.append((Component)Component.translatable((String)"key.keyboard.shift"));
            }
            return Component.translatable((String)((Boolean)ModClient.CONFIG.keybinds.invert.value() != false ? "enchiridion.hide_categories.message" : "enchiridion.expand_categories.message"), (Object[])new Object[]{keybind});
        }
        return Component.translatable((String)"enchiridion.expand_categories.message", (Object[])new Object[]{keybind});
    }

    private static boolean hasDisplayTooltip(List<Component> components) {
        if (Enchiridion.getHelper().isModLoaded("item-descriptions") && ModHelpers.useInternalEnchantmentDescriptions()) {
            return (Boolean)ModClient.CONFIG.hint.enabled.value();
        }
        return components.stream().anyMatch(component -> TextUtil.checkTranslatableKey(component, contents -> contents.getKey().equals("enchdesc.activate.message")));
    }

    private static boolean isEnchantmentDescription(Component component) {
        return TextUtil.checkTranslatableKey(component, contents -> contents.getKey().startsWith("enchantment.") && (contents.getKey().endsWith(".desc") || contents.getKey().endsWith(".description")));
    }

    private static boolean checkTranslatableKey(Component component, Predicate<TranslatableContents> predicate) {
        TranslatableContents translatable;
        ComponentContents contents = null;
        if (component instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)component;
            if (mutable.getSiblings().stream().anyMatch(c -> TextUtil.checkTranslatableKey(c, predicate))) {
                return true;
            }
            contents = mutable.getContents();
        }
        if (contents == null) {
            return false;
        }
        return contents instanceof TranslatableContents && predicate.test(translatable = (TranslatableContents)contents);
    }

    private static /* synthetic */ TextColor lambda$modifyEnchantmentTooltips$5(Holder finalCategory) {
        return ((EnchantmentCategory)finalCategory.value()).visuals().textColor();
    }
}

