/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util.trades;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchiridionEnchantItemTradeForEmeralds
implements VillagerTrades.ItemListing {
    @Nullable
    private final ItemCost fromItem;
    private final int minEmeraldCost;
    private final int maxEmeraldCost;
    private final ItemStack toItem;
    private final int maxUses;
    private final int villagerXp;
    private final float priceMultiplier;
    private final List<ResourceKey<EnchantmentProvider>> providers;

    public EnchiridionEnchantItemTradeForEmeralds(@Nullable ItemCost fromItem, int emeraldCost, Item toItem, int toItemCount, int maxUses, int villagerXp, float priceMultiplier, List<ResourceKey<EnchantmentProvider>> providers) {
        this(fromItem, emeraldCost, emeraldCost, toItem, toItemCount, maxUses, villagerXp, priceMultiplier, providers);
    }

    public EnchiridionEnchantItemTradeForEmeralds(@Nullable ItemCost fromItem, int minEmeraldCost, int maxEmeraldCost, Item toItem, int toItemCount, int maxUses, int villagerXp, float priceMultiplier, List<ResourceKey<EnchantmentProvider>> providers) {
        this.fromItem = fromItem;
        this.minEmeraldCost = minEmeraldCost;
        this.maxEmeraldCost = maxEmeraldCost;
        this.toItem = new ItemStack((ItemLike)toItem, toItemCount);
        this.maxUses = maxUses;
        this.villagerXp = villagerXp;
        this.priceMultiplier = priceMultiplier;
        this.providers = providers;
    }

    public MerchantOffer getOffer(@NotNull Entity trader, @NotNull RandomSource random) {
        int i = this.maxEmeraldCost == this.minEmeraldCost ? this.minEmeraldCost : this.minEmeraldCost + random.nextInt(Math.max(this.maxEmeraldCost - this.minEmeraldCost, 1));
        ItemStack result = this.toItem.copy();
        for (ResourceKey<EnchantmentProvider> providerKey : this.providers) {
            EnchantmentProvider provider = (EnchantmentProvider)trader.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT_PROVIDER).get(providerKey);
            if (provider == null) continue;
            EnchantmentHelper.updateEnchantments((ItemStack)result, mutable -> provider.enchant(result, mutable, random, trader.level().getCurrentDifficultyAt(trader.blockPosition())));
        }
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, i), Optional.ofNullable(this.fromItem), result, this.maxUses, this.villagerXp, this.priceMultiplier);
    }
}

