/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchiridionCompatibilityKeys {
    private static TagKey<Enchantment> enchantmentTag(String namespace, String path) {
        return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    private static TagKey<Item> itemTag(String namespace, String path) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    private static ResourceKey<Enchantment> enchantmentKey(String namespace, String path) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static class Supplementaries {
        public static final ResourceKey<Enchantment> STASIS = EnchiridionCompatibilityKeys.enchantmentKey("supplementaries", "stasis");
    }

    public static class Origins {
        public static final ResourceKey<Enchantment> WATER_PROTECTION = EnchiridionCompatibilityKeys.enchantmentKey("origins", "water_protection");
    }

    public static class Malum {
        public static final ResourceKey<Enchantment> ANIMATED = EnchiridionCompatibilityKeys.enchantmentKey("malum", "animated");
        public static final ResourceKey<Enchantment> ASCENSION = EnchiridionCompatibilityKeys.enchantmentKey("malum", "ascension");
        public static final ResourceKey<Enchantment> CAPACITATOR = EnchiridionCompatibilityKeys.enchantmentKey("malum", "capacitator");
        public static final ResourceKey<Enchantment> HAUNTED = EnchiridionCompatibilityKeys.enchantmentKey("malum", "haunted");
        public static final ResourceKey<Enchantment> REBOUND = EnchiridionCompatibilityKeys.enchantmentKey("malum", "rebound");
        public static final ResourceKey<Enchantment> REPLENISHING = EnchiridionCompatibilityKeys.enchantmentKey("malum", "replenishing");
        public static final ResourceKey<Enchantment> SPIRIT_PLUNDER = EnchiridionCompatibilityKeys.enchantmentKey("malum", "spirit_plunder");
    }

    public static class FarmersDelight {
        public static final ResourceKey<Enchantment> BACKSTABBING = EnchiridionCompatibilityKeys.enchantmentKey("farmersdelight", "backstabbing");
        public static final TagKey<Enchantment> KNIVES_TOOLS_ITEM_EXCLUDED_SET = EnchiridionCompatibilityKeys.enchantmentTag("enchiridion", "enchiridion/item_excluded_set/tag/farmersdelight/tools/knives");
    }

    public static class DungeonsAndTaverns {
        public static final ResourceKey<Enchantment> ANTIDOTE = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "antidote");
        public static final ResourceKey<Enchantment> BLOWTHROUGH = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "piercing");
        public static final ResourceKey<Enchantment> GHASTED = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "ghasted");
        public static final ResourceKey<Enchantment> GRAVITY = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "gravity");
        public static final ResourceKey<Enchantment> ILLAGERS_BANE = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "illagers_bane");
        public static final ResourceKey<Enchantment> MIGHT = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "power");
        public static final ResourceKey<Enchantment> OUTREACH = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "outreach");
        public static final ResourceKey<Enchantment> PHOTOSYNTHESIS = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "photosynthesis");
        public static final ResourceKey<Enchantment> TRAVELER = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "traveler");
        public static final ResourceKey<Enchantment> TRI_SHOT = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "multishot");
        public static final ResourceKey<Enchantment> WAX_WINGS = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "wax_wings");
        public static final ResourceKey<Enchantment> WITHER_COATED = EnchiridionCompatibilityKeys.enchantmentKey("nova_structures", "wither_coated");
    }

    public static class Create {
        public static final ResourceKey<Enchantment> CAPACITY = EnchiridionCompatibilityKeys.enchantmentKey("create", "capacity");
        public static final ResourceKey<Enchantment> POTATO_RECOVERY = EnchiridionCompatibilityKeys.enchantmentKey("create", "potato_recovery");
        public static final TagKey<Item> POTATO_CANNONS = EnchiridionCompatibilityKeys.itemTag("enchiridion", "create/tools/potato_cannon");
        public static final TagKey<Enchantment> POTATO_CANNON_EXCLUDED_SET = EnchiridionCompatibilityKeys.enchantmentTag("enchiridion", "enchiridion/item_excluded_set/create/potato_cannon");
    }

    public static class Allurement {
        public static final ResourceKey<Enchantment> ALLEVIATING = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "alleviating");
        public static final ResourceKey<Enchantment> LAUNCH = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "launch");
        public static final ResourceKey<Enchantment> OBEDIENCE = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "obedience");
        public static final ResourceKey<Enchantment> REELING = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "reeling");
        public static final ResourceKey<Enchantment> REFORMING = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "reforming");
        public static final ResourceKey<Enchantment> SHOCKWAVE = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "shockwave");
        public static final ResourceKey<Enchantment> SPREAD_OF_AILMENTS = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "spread_of_ailments");
        public static final ResourceKey<Enchantment> VENGEANCE = EnchiridionCompatibilityKeys.enchantmentKey("allurement", "vengeance");
    }

    public static class ConventionalTags {
        public static final TagKey<Item> ARMORS = EnchiridionCompatibilityKeys.itemTag("c", "armors");
        public static final TagKey<Item> TOOLS = EnchiridionCompatibilityKeys.itemTag("c", "tools");
    }
}

