/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.category.CategoryVisuals;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.greenhouseconfig.api.OrderCorrectedRecordCodec;
import house.greenhouse.greenhouseconfig.api.util.DefaultFieldUtil;
import house.greenhouse.greenhouseconfig.api.util.LateHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record EnchiridionConfig(Common common, EnchantingTable enchantingTable, VillagerTrades villagerTrades, @Nullable Client client) {
    public static final EnchiridionConfig SERVER_DEFAULT = new EnchiridionConfig(Common.DEFAULT, EnchantingTable.DEFAULT, VillagerTrades.DEFAULT);
    public static final Codec<EnchiridionConfig> SERVER_CODEC = OrderCorrectedRecordCodec.wrap((Codec)RecordCodecBuilder.create(inst -> inst.group((App)Common.CODEC.forGetter(EnchiridionConfig::common), (App)DefaultFieldUtil.codecWithComments(EnchantingTable.CODEC, (String)"enchanting_table", (Object)EnchantingTable.DEFAULT, (String[])new String[]{"Config values relating to the Enchanting Table."}).forGetter(EnchiridionConfig::enchantingTable), (App)DefaultFieldUtil.codecWithComments(VillagerTrades.CODEC, (String)"villager_trades", (Object)VillagerTrades.DEFAULT, (String[])new String[]{"Config values relating to Villagers' trades."}).forGetter(EnchiridionConfig::villagerTrades)).apply((Applicative)inst, EnchiridionConfig::new)));
    public static final EnchiridionConfig CLIENT_DEFAULT = new EnchiridionConfig(Common.DEFAULT, EnchantingTable.DEFAULT, VillagerTrades.DEFAULT, Client.DEFAULT);
    public static final Codec<EnchiridionConfig> CLIENT_CODEC = OrderCorrectedRecordCodec.wrap((Codec)RecordCodecBuilder.create(inst -> inst.group((App)Common.CODEC.forGetter(EnchiridionConfig::common), (App)DefaultFieldUtil.codecWithComments(EnchantingTable.CODEC, (String)"enchanting_table", (Object)EnchantingTable.DEFAULT, (String[])new String[]{"Config values relating to the Enchanting Table."}).forGetter(EnchiridionConfig::enchantingTable), (App)DefaultFieldUtil.codecWithComments(VillagerTrades.CODEC, (String)"villager_trades", (Object)VillagerTrades.DEFAULT, (String[])new String[]{"Config values relating to Villagers' trades."}).forGetter(EnchiridionConfig::villagerTrades), (App)Client.CODEC.forGetter(EnchiridionConfig::client)).apply((Applicative)inst, EnchiridionConfig::new)));

    public EnchiridionConfig(Common common, EnchantingTable enchantingTable, VillagerTrades villagerTrades) {
        this(common, enchantingTable, villagerTrades, null);
    }

    public static StreamCodec<FriendlyByteBuf, EnchiridionConfig> streamCodec(Client client) {
        return StreamCodec.composite(Common.STREAM_CODEC, EnchiridionConfig::common, EnchantingTable.STREAM_CODEC, EnchiridionConfig::enchantingTable, VillagerTrades.STREAM_CODEC, EnchiridionConfig::villagerTrades, (common, enchantingTable, villagerTrades) -> new EnchiridionConfig((Common)common, (EnchantingTable)enchantingTable, (VillagerTrades)villagerTrades, client));
    }

    public record Common(boolean enableCategories) {
        private static final Common DEFAULT = new Common(true);
        public static final MapCodec<Common> CODEC = OrderCorrectedRecordCodec.wrap((MapCodec)RecordCodecBuilder.mapCodec(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"enable_categories", (Object)DEFAULT.enableCategories(), (String[])new String[]{"Whether Enchiridion's categorical enchantment system is enabled.", "", "Categories modify the applicability of enchantments, making them mutually exclusive with ones of the same category."}).forGetter(Common::enableCategories)).apply((Applicative)inst, Common::new)));
        public static final StreamCodec<FriendlyByteBuf, Common> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Common::enableCategories, Common::new);
    }

    public record EnchantingTable(boolean modifyEnchantingTableLogic, CostLogic costLogic, boolean allowEnchantingTableLevelUps) {
        private static final EnchantingTable DEFAULT = new EnchantingTable(true, CostLogic.DEFAULT, true);
        public static final Codec<EnchantingTable> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"modify_enchanting_table_logic", (Object)DEFAULT.modifyEnchantingTableLogic(), (String[])new String[]{"Whether Enchiridion should modify enchanting table logic.", "", "If enabled, the enchanting table will always provide you with a specific amount of enchantments when", "rolling on the enchanting table depending on the enchant level, with a chance to get an extra enchantment.", "", "If categories are enabled, the same category will never roll twice."}).forGetter(EnchantingTable::modifyEnchantingTableLogic), (App)DefaultFieldUtil.codecWithComments(CostLogic.CODEC, (String)"cost_logic", (Object)DEFAULT.costLogic(), (String[])new String[]{"Fields regarding the Enchanting Table's costs and what is gained from those costs."}).forGetter(EnchantingTable::costLogic), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"allow_enchanting_table_level_ups", (Object)DEFAULT.allowEnchantingTableLevelUps(), (String[])new String[]{"Whether Enchiridion should modify the enchanting table to allow levelling up enchanted items."}).forGetter(EnchantingTable::allowEnchantingTableLevelUps)).apply((Applicative)inst, EnchantingTable::new));
        public static final StreamCodec<FriendlyByteBuf, EnchantingTable> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, EnchantingTable::modifyEnchantingTableLogic, CostLogic.STREAM_CODEC, EnchantingTable::costLogic, (StreamCodec)ByteBufCodecs.BOOL, EnchantingTable::allowEnchantingTableLevelUps, EnchantingTable::new);

        public record CostLogic(float costMultiplier, float effectivenessMultiplier, int mediumLevelMin, int highLevelMin) {
            public static final CostLogic DEFAULT = new CostLogic(0.67f, 0.75f, 7, 15);
            public static final Codec<CostLogic> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.FLOAT, (String)"cost_multiplier", (Object)Float.valueOf(DEFAULT.costMultiplier()), (String[])new String[]{"A multiplier for determining the cost of a singular enchant."}).forGetter(CostLogic::costMultiplier), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.FLOAT, (String)"effectiveness_multiplier", (Object)Float.valueOf(DEFAULT.effectivenessMultiplier()), (String[])new String[]{"A multiplier for determining which level to enchant at, relative to the unmodified enchantment cost."}).forGetter(CostLogic::effectivenessMultiplier), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.INT, (String)"medium_level_minimum", (Object)DEFAULT.mediumLevelMin(), (String[])new String[]{"The minimum level for an Enchanting Table enchant to be considered a medium level enchant.", "Medium level enchants by default will roll for two enchantments.", "", "If modify_enchanting_table_logic is disabled, this will not come into effect."}).forGetter(CostLogic::mediumLevelMin), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.INT, (String)"high_level_minimum", (Object)DEFAULT.highLevelMin(), (String[])new String[]{"The minimum level for an Enchanting Table enchant to be considered a high level enchant.", "High level enchants by default will roll for three enchantments.", "", "If modify_enchanting_table_logic is disabled, this will not come into effect."}).forGetter(CostLogic::highLevelMin)).apply((Applicative)inst, CostLogic::new));
            public static final StreamCodec<FriendlyByteBuf, CostLogic> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, CostLogic::costMultiplier, (StreamCodec)ByteBufCodecs.FLOAT, CostLogic::effectivenessMultiplier, (StreamCodec)ByteBufCodecs.INT, CostLogic::mediumLevelMin, (StreamCodec)ByteBufCodecs.INT, CostLogic::highLevelMin, CostLogic::new);
        }
    }

    public record VillagerTrades(ModifiedTrades modifyTrades, boolean simplifyExperimentalArmorerTrades) {
        private static final VillagerTrades DEFAULT = new VillagerTrades(ModifiedTrades.DEFAULT, true);
        public static final Codec<VillagerTrades> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments(ModifiedTrades.CODEC, (String)"enable_modified_trades", (Object)ModifiedTrades.DEFAULT, (String[])new String[]{"Whether Enchiridion should modify specific villager profession trades.", "NOTICE: Existing villager trades will not be updated to match these config settings."}).forGetter(VillagerTrades::modifyTrades), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"simplify_experimental_armorer_trades", (Object)DEFAULT.simplifyExperimentalArmorerTrades(), (String[])new String[]{"Whether Enchiridion should simplify the Experimental Datapack's Armorer trades.", "NOTICE: Existing villager trades will not be updated to match this config setting.", "", "When enabled whilst using the Experimental Feature Toggle...", "Expert Armorer Villagers will always trade two pieces of either Iron or Chainmail Armor", "depending on their biome variant.", "Master Armorer villagers will always trade two specific pieces of Diamond armor", "using Enchiridion's enchantment pool for their biome variant.", "", "This will automatically be disabled if Enchiridion Armorer trades are disabled."}).forGetter(VillagerTrades::simplifyExperimentalArmorerTrades)).apply((Applicative)inst, VillagerTrades::new));
        public static final StreamCodec<FriendlyByteBuf, VillagerTrades> STREAM_CODEC = StreamCodec.composite(ModifiedTrades.STREAM_CODEC, VillagerTrades::modifyTrades, (StreamCodec)ByteBufCodecs.BOOL, VillagerTrades::simplifyExperimentalArmorerTrades, VillagerTrades::new);

        public record ModifiedTrades(boolean librarian, boolean armorer, boolean toolsmith, boolean weaponsmith) {
            private static final ModifiedTrades DEFAULT = new ModifiedTrades(true, true, true, true);
            public static final Codec<ModifiedTrades> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"librarian", (Object)DEFAULT.librarian(), (String[])new String[]{"Whether Librarian trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Librarian book trades before Master profession level are", "biome variant dependent Primaries, Secondaries and Tertiaries.", "", "At Master level, Librarians will trade either Unbreaking or Mending depending", "on their biome variant.", "", "Book prices are far less swingy, gossip affects book prices less.", "Additionally, Librarians will generally trade lower levelled enchantments.", "At least one Book trade is guaranteed to exist at each new profession level."}).forGetter(ModifiedTrades::librarian), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"armorer", (Object)DEFAULT.armorer(), (String[])new String[]{"Whether Armorer trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Armorer armor trades will use specific", "enchantments from the Librarian pool, with expert trades enchanting with", "this pool at a very low level, and master trades enchanting with this pool", "at a low level."}).forGetter(ModifiedTrades::armorer), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"toolsmith", (Object)DEFAULT.toolsmith(), (String[])new String[]{"Whether Toolsmith trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Toolsmith tool trades will use specific", "enchantments from the Librarian pool, with expert trades enchanting with", "this pool at a very low level, and master trades enchanting with this pool", "at a low level."}).forGetter(ModifiedTrades::toolsmith), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"weaponsmith", (Object)DEFAULT.weaponsmith(), (String[])new String[]{"Whether Weaponsmith trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Weaponsmith weapon trades will use specific", "enchantments from the Librarian pool, with expert trades enchanting with", "this pool at a very low level, and master trades enchanting with this pool", "at a low level."}).forGetter(ModifiedTrades::weaponsmith)).apply((Applicative)inst, ModifiedTrades::new));
            public static final StreamCodec<FriendlyByteBuf, ModifiedTrades> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ModifiedTrades::librarian, (StreamCodec)ByteBufCodecs.BOOL, ModifiedTrades::armorer, (StreamCodec)ByteBufCodecs.BOOL, ModifiedTrades::toolsmith, (StreamCodec)ByteBufCodecs.BOOL, ModifiedTrades::weaponsmith, ModifiedTrades::new);
        }
    }

    public record Client(Map<LateHolder<EnchantmentCategory>, CategoryVisuals> categoryColorOverrides) {
        private static final Client DEFAULT = new Client((Map<LateHolder<EnchantmentCategory>, CategoryVisuals>)Object2ObjectMaps.emptyMap());
        public static final MapCodec<Client> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.unboundedMap((Codec)LateHolder.codec((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)Enchiridion.id("enchantment_category"))), CategoryVisuals.CODEC), (String)"category_visual_overrides", DEFAULT.categoryColorOverrides(), (String[])new String[]{"Overrides for setting the visuals of enchantment categories.", "", "This can affect the text color and the book color/model for the enchanted book.", "You may either specify a string to set both text and book color,", "or an object with 'text_color', 'book_color' and 'item_model_index' fields.", "", "'item_model_index' may be used through the 'enchiridion:first_enchantment_category' model override predicate.", "", "If an 'item_model_index' field is not specified, a generic model will be used, which is tinted based on the", "'book_color' field or the 'color' field if the 'book_color' field is not specified.", "", "Examples:", "{", "\t\"enchiridion:primary\": \"red\",", "\t\"enchiridion:secondary\": {", "\t\t\"text_color\": \"#00FF00\",", "\t\t\"book_color\": \"#00AA00\"", "\t},", "\t\"enchiridion:tertiary\": {", "\t\t\"text_color\": \"#00AA00\"", "\t\t\"item_model_index\": 0.6", "\t}", "}"}).forGetter(Client::categoryColorOverrides)).apply((Applicative)inst, Client::new));

        @NotNull
        public Optional<CategoryVisuals> getBookVisuals(Holder<EnchantmentCategory> category) {
            return this.categoryColorOverrides.entrySet().stream().filter(entry -> ((LateHolder)entry.getKey()).is(category)).map(Map.Entry::getValue).findFirst();
        }
    }
}

