/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.category;

import com.mojang.serialization.Codec;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ItemEnchantmentCategories(Object2ObjectMap<Holder<EnchantmentCategory>, List<Holder<Enchantment>>> enchantmentCategories) {
    public static final ItemEnchantmentCategories EMPTY = new ItemEnchantmentCategories((Object2ObjectMap<Holder<EnchantmentCategory>, List<Holder<Enchantment>>>)Object2ObjectMaps.emptyMap());
    public static final Codec<ItemEnchantmentCategories> CODEC = Codec.unboundedMap(EnchantmentCategory.CODEC, (Codec)Enchantment.CODEC.listOf().xmap(ObjectArrayList::new, Function.identity())).xmap(Object2ObjectArrayMap::new, Function.identity()).xmap(ItemEnchantmentCategories::new, categories -> categories.enchantmentCategories);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantmentCategories> STREAM_CODEC = ByteBufCodecs.map(Object2ObjectArrayMap::new, EnchantmentCategory.STREAM_CODEC, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENCHANTMENT).apply(ByteBufCodecs.collection(ObjectArrayList::new))).map(ItemEnchantmentCategories::new, itemEnchantmentCategories -> itemEnchantmentCategories.enchantmentCategories);

    public Object2ObjectMap<Holder<EnchantmentCategory>, List<Holder<Enchantment>>> getCategories() {
        return Object2ObjectMaps.unmodifiable(this.enchantmentCategories);
    }

    @Nullable
    public Holder<EnchantmentCategory> findFirstCategory(Holder<Enchantment> enchantment) {
        return this.enchantmentCategories.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(enchantment)).max(Comparator.comparingInt(value -> !((Holder)value.getKey()).isBound() ? -1 : ((EnchantmentCategory)((Holder)value.getKey()).value()).priority())).map(Map.Entry::getKey).orElse(null);
    }

    public boolean hasCategory(Holder<EnchantmentCategory> category) {
        return this.enchantmentCategories.keySet().stream().anyMatch(categoryHolder -> categoryHolder.is(category));
    }

    public List<Holder<Enchantment>> get(Holder<EnchantmentCategory> category) {
        if (!this.enchantmentCategories.containsKey(category)) {
            return List.of();
        }
        return List.copyOf((Collection)this.enchantmentCategories.get(category));
    }

    public boolean isValid(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment, DataComponentType<ItemEnchantments> type) {
        if (type == DataComponents.STORED_ENCHANTMENTS) {
            return this.isStoredValid(category, enchantment);
        }
        return this.isValid(category, enchantment);
    }

    public boolean isValid(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
        if (!category.isBound()) {
            return false;
        }
        if (!((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)) {
            return false;
        }
        if (((EnchantmentCategory)category.value()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
            return true;
        }
        return ((List)this.enchantmentCategories.get(category)).size() < ((EnchantmentCategory)category.value()).limit().get();
    }

    public boolean isStoredValid(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
        if (!category.isBound()) {
            return false;
        }
        if (!((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)) {
            return false;
        }
        if (((EnchantmentCategory)category.value()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
            return true;
        }
        HolderSet holders = ((Enchantment)enchantment.value()).definition().primaryItems().orElse(((Enchantment)enchantment.value()).definition().supportedItems());
        long count = ((List)this.enchantmentCategories.get(category)).stream().filter(e -> {
            HolderSet enchantmentItems = ((Enchantment)e.value()).definition().primaryItems().orElse(((Enchantment)e.value()).definition().supportedItems());
            return enchantmentItems.stream().anyMatch(arg_0 -> ((HolderSet)holders).contains(arg_0));
        }).count();
        return count < (long)((EnchantmentCategory)category.value()).limit().get().intValue();
    }

    public boolean contains(Holder<Enchantment> enchantment) {
        return this.enchantmentCategories.values().stream().anyMatch(holders -> holders.contains(enchantment));
    }

    public boolean isEmpty() {
        return this.enchantmentCategories.isEmpty() || this.enchantmentCategories.values().stream().allMatch(List::isEmpty);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        Object2ObjectMap<Holder<EnchantmentCategory>, List<Holder<Enchantment>>> categories;
        if (this == other) {
            return true;
        }
        if (!(other instanceof ItemEnchantmentCategories)) return false;
        ItemEnchantmentCategories itemEnchantmentCategories = (ItemEnchantmentCategories)other;
        try {
            Object2ObjectMap<Holder<EnchantmentCategory>, List<Holder<Enchantment>>> object2ObjectMap;
            categories = object2ObjectMap = itemEnchantmentCategories.enchantmentCategories();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return categories.equals(this.enchantmentCategories);
    }

    @Override
    @NotNull
    public String toString() {
        return "ItemEnchantmentCategories{" + String.valueOf(this.enchantmentCategories) + "}";
    }

    public static class Mutable {
        private final Object2ObjectMap<Holder<EnchantmentCategory>, List<Holder<Enchantment>>> enchantmentCategories;

        public Mutable(ItemEnchantmentCategories categories) {
            this.enchantmentCategories = new Object2ObjectArrayMap(categories.enchantmentCategories);
        }

        public int size() {
            return this.enchantmentCategories.size();
        }

        public boolean isEmpty() {
            return this.enchantmentCategories.isEmpty();
        }

        public boolean contains(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
            return ((List)this.enchantmentCategories.getOrDefault(category, (Object)ObjectLists.emptyList())).contains(enchantment);
        }

        public boolean contains(Holder<Enchantment> enchantment) {
            return this.enchantmentCategories.values().stream().anyMatch(holders -> holders.contains(enchantment));
        }

        public void overwrite(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
            this.remove(enchantment);
            this.add(category, enchantment);
        }

        public void add(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
            if (this.contains(enchantment)) {
                return;
            }
            ((List)this.enchantmentCategories.computeIfAbsent(category, category1 -> new ObjectArrayList())).add(enchantment);
        }

        @Deprecated
        public void remove(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
            if (!this.contains(enchantment)) {
                return;
            }
            ((List)this.enchantmentCategories.getOrDefault(category, Collections.emptyList())).remove(enchantment);
            if (((List)this.enchantmentCategories.getOrDefault(category, Collections.emptyList())).isEmpty()) {
                this.enchantmentCategories.remove(category);
            }
        }

        public void remove(Holder<Enchantment> enchantment) {
            if (!this.contains(enchantment)) {
                return;
            }
            Holder category = this.enchantmentCategories.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(enchantment)).max(Comparator.comparingInt(value -> !((Holder)value.getKey()).isBound() ? -1 : ((EnchantmentCategory)((Holder)value.getKey()).value()).priority())).map(Map.Entry::getKey).orElse(null);
            if (category == null) {
                return;
            }
            this.remove((Holder<EnchantmentCategory>)category, enchantment);
        }

        public boolean isValid(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment, DataComponentType<ItemEnchantments> type) {
            if (type == DataComponents.STORED_ENCHANTMENTS) {
                return this.isStoredValid(category, enchantment);
            }
            return this.isValid(category, enchantment);
        }

        private boolean isValid(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
            if (!category.isBound()) {
                return false;
            }
            if (!((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)) {
                return false;
            }
            if (((EnchantmentCategory)category.value()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
                return true;
            }
            return ((List)this.enchantmentCategories.get(category)).size() < ((EnchantmentCategory)category.value()).limit().get();
        }

        private boolean isStoredValid(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment) {
            if (!category.isBound()) {
                return false;
            }
            if (!((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment)) {
                return false;
            }
            if (((EnchantmentCategory)category.value()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
                return true;
            }
            HolderSet holders = ((Enchantment)enchantment.value()).definition().primaryItems().orElse(((Enchantment)enchantment.value()).definition().supportedItems());
            long count = ((List)this.enchantmentCategories.get(category)).stream().filter(e -> {
                HolderSet enchantmentItems = ((Enchantment)e.value()).definition().primaryItems().orElse(((Enchantment)e.value()).definition().supportedItems());
                return enchantmentItems.stream().anyMatch(arg_0 -> ((HolderSet)holders).contains(arg_0));
            }).count();
            return count == 0L;
        }

        public ItemEnchantmentCategories toImmutable() {
            if (this.enchantmentCategories.isEmpty()) {
                return EMPTY;
            }
            return new ItemEnchantmentCategories(this.enchantmentCategories);
        }

        public int hashCode() {
            return this.enchantmentCategories.hashCode();
        }

        public String toString() {
            return "ItemEnchantmentCategories.Mutable{" + String.valueOf(this.enchantmentCategories) + "}";
        }
    }
}

