/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;

public record DamageBasedOnItemEffect(Holder<DamageType> damageType, Optional<EnchantmentValueEffect> damageModifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<DamageBasedOnItemEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(DamageBasedOnItemEffect::damageType), (App)EnchantmentValueEffect.CODEC.optionalFieldOf("damage_modifier").forGetter(DamageBasedOnItemEffect::damageModifier)).apply((Applicative)inst, DamageBasedOnItemEffect::new));

    public void apply(@NotNull ServerLevel serverLevel, int i, EnchantedItemInUse enchantedItemInUse, @NotNull Entity entity, @NotNull Vec3 vec3) {
        LivingEntity owner = enchantedItemInUse.owner();
        MutableFloat amount = new MutableFloat(0.0f);
        DamageSource source = new DamageSource(this.damageType, (Entity)owner);
        amount.setValue(EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)enchantedItemInUse.itemStack(), (Entity)entity, (DamageSource)source, (float)amount.getValue().floatValue()));
        amount.setValue(amount.getValue().floatValue() + (float)owner.getAttributeValue(Attributes.ATTACK_DAMAGE));
        if (owner instanceof Player) {
            amount.setValue(enchantedItemInUse.itemStack().getItem().getAttackDamageBonus(entity, amount.getValue().floatValue(), source));
        }
        this.damageModifier.ifPresent(effect -> amount.setValue(this.damageModifier.get().process(i, serverLevel.getRandom(), amount.getValue().floatValue())));
        entity.hurt(source, amount.getValue().floatValue());
    }

    @NotNull
    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

