/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.serialization.MapCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ExtinguishEffect
implements EnchantmentEntityEffect {
    public static final ExtinguishEffect INSTANCE = new ExtinguishEffect();
    public static final MapCodec<ExtinguishEffect> CODEC = MapCodec.unit((Object)INSTANCE);

    public void apply(@NotNull ServerLevel serverLevel, int level, @NotNull EnchantedItemInUse enchantedItem, Entity entity, @NotNull Vec3 origin) {
        if (entity.wasOnFire && serverLevel.getBlockStatesIfLoaded(entity.getBoundingBox().deflate(1.0E-6)).noneMatch(block -> block.is(BlockTags.FIRE) || block.is(Blocks.LAVA))) {
            if (!entity.isSilent()) {
                serverLevel.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GENERIC_EXTINGUISH_FIRE, entity.getSoundSource(), 0.7f, 1.6f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.4f);
            }
            entity.clearFire();
        }
    }

    @NotNull
    public MapCodec<ExtinguishEffect> codec() {
        return CODEC;
    }
}

