/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record FreezeEffect(LevelBasedValue duration) implements EnchantmentEntityEffect
{
    public static final MapCodec<FreezeEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(FreezeEffect::duration)).apply((Applicative)inst, FreezeEffect::new));

    public void apply(@NotNull ServerLevel serverLevel, int level, @NotNull EnchantedItemInUse enchantedItem, Entity entity, @NotNull Vec3 origin) {
        int i = Mth.floor((float)this.duration.calculate(level));
        if (i < entity.getTicksFrozen()) {
            return;
        }
        entity.setTicksFrozen(i);
        Enchiridion.getHelper().setFrozenByEnchantment(entity, true);
    }

    @NotNull
    public MapCodec<FreezeEffect> codec() {
        return CODEC;
    }
}

