/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity.common;

import com.mojang.serialization.MapCodec;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.SidedEnchantmentEntityEffectInstance;
import house.greenhouse.enchiridion.api.util.Side;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AllOfSidedEnchantmentEntityEffect
implements SidedEnchantmentEntityEffectInstance,
AllOf {
    public static final MapCodec<AllOfSidedEnchantmentEntityEffect> CODEC = AllOf.codec(SidedEnchantmentEntityEffectInstance.CODEC, AllOfSidedEnchantmentEntityEffect::new, AllOfSidedEnchantmentEntityEffect::effects);
    private final List<SidedEnchantmentEntityEffectInstance> effects;
    private EnumSet<Side> validSides;

    public AllOfSidedEnchantmentEntityEffect(List<SidedEnchantmentEntityEffectInstance> effects) {
        this.effects = effects;
    }

    public List<SidedEnchantmentEntityEffectInstance> effects() {
        return this.effects;
    }

    @Override
    public void apply(Level level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        this.effects.forEach(effect -> effect.apply(level, enchantmentLevel, item, entity, origin));
    }

    @Override
    public MapCodec<? extends SidedEnchantmentEntityEffectInstance> codec() {
        return CODEC;
    }

    @Override
    public EnumSet<Side> validSides() {
        if (this.validSides == null) {
            this.validSides = EnumSet.copyOf(this.effects.stream().flatMap(inst -> inst.validSides().stream()).collect(Collectors.toSet()));
        }
        return this.validSides;
    }
}

