/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import org.jetbrains.annotations.NotNull;

public record EnchantInCategories(int level, HolderSet<Enchantment> enchantments, HolderSet<EnchantmentCategory> categories) implements EnchantmentProvider
{
    public static final ResourceLocation ID = Enchiridion.id("enchant_in_categories");
    public static final MapCodec<EnchantInCategories> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("level").forGetter(EnchantInCategories::level), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantments").forGetter(EnchantInCategories::enchantments), (App)RegistryCodecs.homogeneousList(EnchiridionRegistries.ENCHANTMENT_CATEGORY).fieldOf("categories").forGetter(EnchantInCategories::categories)).apply((Applicative)inst, EnchantInCategories::new));

    public void enchant(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ItemEnchantments.Mutable mutable, @NotNull RandomSource random, @NotNull DifficultyInstance difficulty) {
        List enchantWith = EnchantmentHelper.selectEnchantment((RandomSource)random, (ItemStack)stack, (int)this.level, this.enchantments.stream().filter(enchantment -> this.categories.stream().anyMatch(category -> ((EnchantmentCategory)category.value()).acceptedEnchantments().contains(enchantment))));
        enchantWith.forEach(enchantmentInstance -> mutable.upgrade(enchantmentInstance.enchantment, enchantmentInstance.level));
    }

    @NotNull
    public MapCodec<EnchantInCategories> codec() {
        return CODEC;
    }
}

