/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import java.util.Set;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record PreviousAttackTargetDistanceLootCondition(MinMaxBounds.Doubles range) implements LootItemCondition
{
    public static final MapCodec<PreviousAttackTargetDistanceLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)MinMaxBounds.Doubles.CODEC.fieldOf("range").forGetter(PreviousAttackTargetDistanceLootCondition::range)).apply((Applicative)inst, PreviousAttackTargetDistanceLootCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public static LootItemCondition.Builder distance(MinMaxBounds.Doubles range) {
        return () -> new PreviousAttackTargetDistanceLootCondition(range);
    }

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.getParam(LootContextParams.THIS_ENTITY);
        Entity target = context.getLevel().getEntity(Enchiridion.getHelper().getPreviousAttackTarget(entity));
        if (target == null || !target.isAlive()) {
            return false;
        }
        return this.range.matches(target.position().distanceTo((Vec3)context.getParam(LootContextParams.ORIGIN)));
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY, LootContextParams.ORIGIN);
    }
}

