/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.mixin.Accessor_LivingEntity;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record PreviousDamageSourceLootCondition(Optional<DamageSourcePredicate> predicate, Optional<IntRange> timer) implements LootItemCondition
{
    public static final MapCodec<PreviousDamageSourceLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DamageSourcePredicate.CODEC.optionalFieldOf("predicate").forGetter(PreviousDamageSourceLootCondition::predicate), (App)IntRange.CODEC.optionalFieldOf("timer").forGetter(PreviousDamageSourceLootCondition::timer)).apply((Applicative)inst, PreviousDamageSourceLootCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    @NotNull
    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext context) {
        Object object = context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (!(object instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)object;
        long damageTimer = context.getLevel().getGameTime() - ((Accessor_LivingEntity)living).enchiridion$getLastDamageStamp();
        return this.predicate.map(predicate -> predicate.matches(context.getLevel(), (Vec3)context.getParam(LootContextParams.ORIGIN), living.getLastDamageSource())).orElse(true) != false && (this.timer.isEmpty() || this.timer.get().test(context, (int)damageTimer));
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY, LootContextParams.ORIGIN);
    }
}

