/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.subpredicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.duck.Duck_PlayerAttackStrength;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerSubPredicate(Optional<MinMaxBounds.Doubles> attackStrength) implements EntitySubPredicate
{
    public static final MapCodec<PlayerSubPredicate> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("attack_strength").forGetter(PlayerSubPredicate::attackStrength)).apply((Applicative)inst, PlayerSubPredicate::new));

    public boolean matches(@NotNull Entity entity, @NotNull ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return this.attackStrength.map(doubles -> doubles.matches((double)((Duck_PlayerAttackStrength)player).enchiridion$getAttackStrength())).orElse(true);
    }

    @NotNull
    public MapCodec<PlayerSubPredicate> codec() {
        return CODEC;
    }

    public static class Builder {
        private Optional<MinMaxBounds.Doubles> attackStrength = Optional.empty();

        protected Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder attackStrength(MinMaxBounds.Doubles attackStrength) {
            this.attackStrength = Optional.of(attackStrength);
            return this;
        }

        public PlayerSubPredicate build() {
            return new PlayerSubPredicate(this.attackStrength);
        }
    }
}

