/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;

public record RangeEnchantmentValue(List<Pair<Range, EnchantmentValueEffect>> values) implements EnchantmentValueEffect
{
    public static final MapCodec<RangeEnchantmentValue> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Range.VALUE_CODEC.listOf().fieldOf("values").forGetter(RangeEnchantmentValue::values)).apply((Applicative)inst, RangeEnchantmentValue::new));

    public static Builder builder() {
        return new Builder();
    }

    public float process(int enchantmentLevel, @NotNull RandomSource random, float value) {
        MutableFloat newVal = new MutableFloat(value);
        List<Pair> applicable = this.values.stream().filter(e -> {
            float min = ((Range)e.getFirst()).minInclusive().map(levelBasedValue -> Float.valueOf(levelBasedValue.calculate(enchantmentLevel))).orElse(Float.valueOf(0.0f)).floatValue();
            if (((Range)e.getFirst()).minInclusive().isPresent() && min > newVal.getValue().floatValue()) {
                return false;
            }
            float max = ((Range)e.getFirst()).maxExclusive().map(levelBasedValue -> Float.valueOf(levelBasedValue.calculate(enchantmentLevel))).orElse(Float.valueOf(0.0f)).floatValue();
            return ((Range)e.getFirst()).maxExclusive().isEmpty() || max > newVal.getValue().floatValue();
        }).toList();
        for (Pair entry : applicable) {
            newVal.setValue(((EnchantmentValueEffect)entry.getSecond()).process(enchantmentLevel, random, newVal.getValue().floatValue()));
        }
        return newVal.getValue().floatValue();
    }

    @NotNull
    public MapCodec<? extends EnchantmentValueEffect> codec() {
        return CODEC;
    }

    public static class Builder {
        private final List<Pair<Range, EnchantmentValueEffect>> values = new ArrayList<Pair<Range, EnchantmentValueEffect>>();

        private Builder() {
        }

        public Builder minInclusive(LevelBasedValue minInclusive, EnchantmentValueEffect value) {
            this.values.add((Pair<Range, EnchantmentValueEffect>)Pair.of((Object)new Range(Optional.of(minInclusive), Optional.empty()), (Object)value));
            return this;
        }

        public Builder maxExclusive(LevelBasedValue maxExclusive, EnchantmentValueEffect value) {
            this.values.add((Pair<Range, EnchantmentValueEffect>)Pair.of((Object)new Range(Optional.empty(), Optional.of(maxExclusive)), (Object)value));
            return this;
        }

        public Builder betweenClamped(LevelBasedValue minInclusive, LevelBasedValue maxExclusive, EnchantmentValueEffect value) {
            this.values.add((Pair<Range, EnchantmentValueEffect>)Pair.of((Object)new Range(Optional.of(minInclusive), Optional.of(maxExclusive)), (Object)value));
            return this;
        }

        public RangeEnchantmentValue build() {
            return new RangeEnchantmentValue(this.values);
        }
    }

    private record Range(Optional<LevelBasedValue> minInclusive, Optional<LevelBasedValue> maxExclusive) {
        private static final Codec<Range> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LevelBasedValue.CODEC.optionalFieldOf("min_inclusive").forGetter(Range::minInclusive), (App)LevelBasedValue.CODEC.optionalFieldOf("max_exclusive").forGetter(Range::maxExclusive)).apply((Applicative)inst, Range::new));
        private static final Codec<Range> CODEC = DIRECT_CODEC.validate(range -> {
            if (range.minInclusive().isEmpty() && range.maxExclusive().isEmpty()) {
                return DataResult.error(() -> "Cannot create range without either a 'min_inclusive' or 'max_exclusive' value.");
            }
            if (range.maxExclusive().isPresent() && range.minInclusive().isPresent() && range.maxExclusive().get().calculate(1) < range.minInclusive().get().calculate(1)) {
                return DataResult.error(() -> "Cannot create range that has a 'max_exclusive' value that is smaller than the 'min_inclusive' value.");
            }
            return DataResult.success((Object)range);
        });
        private static final Codec<Pair<Range, EnchantmentValueEffect>> VALUE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("range").forGetter(Pair::getFirst), (App)EnchantmentValueEffect.CODEC.fieldOf("value").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
    }
}

