/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.block.entity.SiphoningTableBlockEntity;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SiphoningTableRenderer
implements BlockEntityRenderer<SiphoningTableBlockEntity> {
    public static final Material BOOK_LOCATION = new Material(InventoryMenu.BLOCK_ATLAS, Enchiridion.id("entity/siphoning_table_book"));
    private final ItemRenderer itemRenderer;
    private final BookModel bookModel;

    public SiphoningTableRenderer(BlockEntityRendererProvider.Context context) {
        this.bookModel = new BookModel(context.bakeLayer(ModelLayers.BOOK));
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(SiphoningTableBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float f1;
        if (!blockEntity.hasBook() && blockEntity.getItem(2).isEmpty() && blockEntity.getItem(3).isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.75f, 0.5f);
        float f = Mth.lerp((float)partialTick, (float)blockEntity.oldBookY, (float)blockEntity.bookY);
        poseStack.translate(0.0f, f, 0.0f);
        for (f1 = blockEntity.rot - blockEntity.oldRot; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = blockEntity.oldRot + f1 * partialTick;
        poseStack.mulPose(Axis.YP.rotation(-f2));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        float f3 = Mth.lerp((float)partialTick, (float)blockEntity.oldFlip, (float)blockEntity.flip);
        float f4 = Mth.frac((float)f3) * 1.6f - 0.3f;
        float f5 = Mth.frac((float)f3) * 1.6f - 0.3f;
        if (blockEntity.hasBook()) {
            this.bookModel.setupAnim(f, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), blockEntity.open);
            VertexConsumer vertexconsumer = BOOK_LOCATION.buffer(bufferSource, RenderType::entitySolid);
            this.bookModel.render(poseStack, vertexconsumer, packedLight, packedOverlay, -1);
        } else {
            poseStack.translate(0.0f, -0.184f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.scale(1.5f, 1.5f, 1.5f);
            ItemStack stack = blockEntity.getItem(3).isEmpty() ? blockEntity.getItem(2) : blockEntity.getItem(3);
            int seed = ItemEntityRenderer.getSeedForItemStack((ItemStack)stack);
            this.itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), seed);
        }
        poseStack.popPose();
    }
}

