/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.client.renderer.entity.model.WhirlpoolModel;
import house.greenhouse.enchiridion.entity.Whirlpool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.NotNull;

public class WhirlpoolRenderer
extends EntityRenderer<Whirlpool> {
    protected final WhirlpoolModel<Whirlpool> model;

    public WhirlpoolRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new WhirlpoolModel(context.bakeLayer(WhirlpoolModel.LAYER_LOCATION));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Whirlpool entity) {
        return Enchiridion.id("textures/entity/whirlpool/whirlpool.png");
    }

    @NotNull
    public ResourceLocation getWhiteWaterTextureLocation() {
        return Enchiridion.id("textures/entity/whirlpool/whirlpool_whitewater.png");
    }

    public void render(@NotNull Whirlpool entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && entity.getOwner() == Minecraft.getInstance().cameraEntity) {
            return;
        }
        float tick = (float)entity.tickCount + partialTick;
        poseStack.pushPose();
        poseStack.translate(entity.getOwner().getX() - entity.getX(), entity.getOwner().getY() - entity.getY(), entity.getOwner().getZ() - entity.getZ());
        poseStack.translate(0.0, (double)(entity.getCurrentHeight(partialTick) / entity.getTargetHeight()) * (0.5 * (double)entity.getTargetHeight()), 0.0);
        poseStack.translate(0.0, entity.getOwner() == null ? 0.0 : (entity.getOwner().getBoundingBox().getYsize() - (double)entity.getOwner().getDimensions(Pose.STANDING).height()) / 2.0, 0.0);
        poseStack.translate(0.0, (double)Mth.sin((float)(tick / 8.0f)) * 0.04, 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotation(tick / 30.0f * (float)Math.PI));
        poseStack.scale(entity.getCurrentWidth(partialTick) / 2.0f, entity.getCurrentHeight(partialTick) / 2.2f, entity.getCurrentWidth(partialTick) / 2.0f);
        poseStack.scale(1.0f + Mth.sin((float)(tick / 8.0f)) * 0.04f, 1.0f + Mth.sin((float)(tick / 8.0f)) * 0.04f, 1.0f + Mth.sin((float)(tick / 8.0f)) * 0.04f);
        this.model.setupAnim(entity, 0.0f, 0.0f, tick, entityYaw, entity.getViewXRot(partialTick));
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY, -16777216 + BiomeColors.getAverageWaterColor((BlockAndTintGetter)entity.level(), (BlockPos)entity.blockPosition()));
        poseStack.scale(1.04f, 1.04f, 1.04f);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getWhiteWaterTextureLocation())), packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }
}

