/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.entity.Whirlpool;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class WhirlpoolModel<T extends Whirlpool>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Enchiridion.id("whirlpool"), "main");
    private final ModelPart bottom;
    private final ModelPart lowerMiddle;
    private final ModelPart upperMiddle;
    private final ModelPart top;
    private float ageInTicks = 0.0f;

    public WhirlpoolModel(ModelPart root) {
        this.bottom = root.getChild("bottom");
        this.lowerMiddle = root.getChild("lower_middle");
        this.upperMiddle = root.getChild("upper_middle");
        this.top = root.getChild("top");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(72, 84).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("lower_middle", CubeListBuilder.create().texOffs(0, 84).addBox(-9.0f, -16.0f, -9.0f, 18.0f, 8.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("upper_middle", CubeListBuilder.create().texOffs(0, 48).addBox(-13.0f, -26.0f, -13.0f, 26.0f, 10.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 0).addBox(-18.0f, -38.0f, -18.0f, 36.0f, 12.0f, 36.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ageInTicks = ageInTicks;
        float tick = ageInTicks / 2.0f;
        float radiusModifier = ((Whirlpool)((Object)entity)).getCurrentWidth();
        this.bottom.setPos(this.bottom.getInitialPose().x + Mth.cos((float)tick) * 0.8f * radiusModifier, this.bottom.y, this.bottom.getInitialPose().z + Mth.sin((float)tick) * 0.8f * radiusModifier);
        this.lowerMiddle.setPos(this.lowerMiddle.getInitialPose().x + Mth.sin((float)tick) * radiusModifier, this.lowerMiddle.y, this.lowerMiddle.getInitialPose().z + Mth.cos((float)tick) * radiusModifier);
        this.upperMiddle.setPos(this.upperMiddle.getInitialPose().x + Mth.cos((float)tick) * 1.2f * radiusModifier, this.upperMiddle.y, this.upperMiddle.getInitialPose().z + Mth.sin((float)tick) * 1.2f * radiusModifier);
        this.top.setPos(this.top.getInitialPose().x + Mth.sin((float)tick) * 1.6f * radiusModifier, this.upperMiddle.y, this.top.getInitialPose().z + Mth.cos((float)tick) * 1.6f * radiusModifier);
    }

    public void renderToBuffer(PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.scale(1.1f, 1.0f, 1.1f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(-(this.ageInTicks + 320.0f) / 8.0f)) * 2.0f));
        this.bottom.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(1.1f, 1.0f, 1.1f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)((this.ageInTicks + 320.0f) / 6.0f)) * 2.0f));
        this.lowerMiddle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(1.1f, 1.0f, 1.1f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(-this.ageInTicks / 4.0f)) * 2.0f));
        this.upperMiddle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(1.1f, 1.0f, 1.1f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(this.ageInTicks / 3.0f)) * 2.0f));
        this.top.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

