/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.sound;

import house.greenhouse.enchiridion.entity.Whirlpool;
import house.greenhouse.enchiridion.registry.EnchiridionSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class WhirlpoolLoopSoundInstance
extends AbstractTickableSoundInstance {
    private final Whirlpool whirlpool;
    private int stopDelay = 0;

    protected WhirlpoolLoopSoundInstance(Whirlpool whirlpool) {
        super((SoundEvent)EnchiridionSoundEvents.WHIRLPOOL_LOOP.value(), SoundSource.NEUTRAL, whirlpool.getRandom());
        this.whirlpool = whirlpool;
        this.x = whirlpool.getX();
        this.y = whirlpool.getY();
        this.z = whirlpool.getZ();
        this.looping = true;
        this.volume = 0.0f;
    }

    public static void start(Whirlpool whirlpool) {
        Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)new WhirlpoolLoopSoundInstance(whirlpool));
    }

    public void tick() {
        if (!this.whirlpool.isRemoved()) {
            this.x = this.whirlpool.getX();
            this.y = this.whirlpool.getY();
            this.z = this.whirlpool.getZ();
            if (this.whirlpool.tickCount % 6 == 0 || this.volume < 0.01f) {
                this.pitch = this.random.nextFloat() * 0.3f + 0.85f;
                this.volume = this.random.nextFloat() * 0.2f + 0.4f;
            }
        } else {
            this.looping = false;
            ++this.stopDelay;
            if (this.stopDelay > 6) {
                this.stop();
                Minecraft.getInstance().getSoundManager().stop((SoundInstance)this);
            }
        }
    }

    public boolean canStartSilent() {
        return true;
    }
}

