/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.duck.Duck_Whirlpool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix4f;

public class WhirlpoolOverlayUtil {
    private static final ResourceLocation WHIRLPOOL = Enchiridion.id("gui/overlay/whirlpool/whirlpool");
    private static final ResourceLocation WHIRLPOOL_WHITEWATER = Enchiridion.id("gui/overlay/whirlpool/whirlpool_whitewater");

    public static void renderWhirlpoolOverlay(Minecraft minecraft, PoseStack pose) {
        if (!minecraft.options.getCameraType().isFirstPerson() || minecraft.level == null || minecraft.cameraEntity == null || ((Duck_Whirlpool)minecraft.cameraEntity).enchiridion$whirlpoolPercentage() < 0.01f) {
            return;
        }
        int alpha = Math.min(Mth.floor((float)(((Duck_Whirlpool)minecraft.cameraEntity).enchiridion$whirlpoolPercentage() * 255.0f)), 255);
        pose.pushPose();
        WhirlpoolOverlayUtil.renderTexture(pose, minecraft.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(WHIRLPOOL), FastColor.ABGR32.color((int)alpha, (int)BiomeColors.getAverageWaterColor((BlockAndTintGetter)minecraft.level, (BlockPos)minecraft.cameraEntity.blockPosition())));
        pose.popPose();
        pose.pushPose();
        WhirlpoolOverlayUtil.renderTexture(pose, minecraft.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(WHIRLPOOL_WHITEWATER), FastColor.ABGR32.color((int)alpha, (int)0xFFFFFF));
        pose.popPose();
    }

    private static void renderTexture(PoseStack pose, TextureAtlasSprite texture, int argb) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        float f6 = texture.getU0();
        float f7 = texture.getU1();
        float f8 = texture.getV0();
        float f9 = texture.getV1();
        pose.scale(1.0f, 0.2f, 1.0f);
        pose.translate(0.0f, -1.2f, 0.0f);
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(f7, f9).setColor(argb);
        bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(f6, f9).setColor(argb);
        bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(f6, f8).setColor(argb);
        bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(f7, f8).setColor(argb);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

