/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.integration.emi.EnchiridionRecipeCategories;
import house.greenhouse.enchiridion.integration.emi.EnchiridionRecipeWorkstations;
import house.greenhouse.enchiridion.integration.emi.handler.SiphoningRecipeHandler;
import house.greenhouse.enchiridion.integration.emi.recipe.EmiSiphoningRecipe;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import house.greenhouse.enchiridion.registry.EnchiridionMenuTypes;
import house.greenhouse.enchiridion.registry.EnchiridionRecipeTypes;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;

@EmiEntrypoint
public class EnchiridionEMIPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addCategory(EnchiridionRecipeCategories.SIPHONING);
        registry.addWorkstation(EnchiridionRecipeCategories.SIPHONING, (EmiIngredient)EnchiridionRecipeWorkstations.SIPHONING_TABLE);
        registry.addRecipeHandler(EnchiridionMenuTypes.SIPHONING, (EmiRecipeHandler)new SiphoningRecipeHandler());
        if (Minecraft.getInstance().level == null) {
            return;
        }
        for (RecipeHolder recipe : registry.getRecipeManager().getAllRecipesFor(EnchiridionRecipeTypes.SIPHONING)) {
            registry.addRecipe((EmiRecipe)new EmiSiphoningRecipe(recipe.id(), Stream.concat(((SiphoningRecipe)recipe.value()).getIngredientsWithAmounts().stream().map(ingredient -> EmiIngredient.of(Arrays.stream(ingredient.ingredient().getItems()).map(stack -> EmiStack.of((ItemStack)stack.copyWithCount(ingredient.amount()))).toList(), (long)ingredient.amount())), Stream.of(EmiIngredient.of(Stream.concat(((SiphoningRecipe)recipe.value()).getEnchantments().values().stream().flatMap(enchantments -> enchantments.keySet().stream().flatMap(enchantmentHolder -> ((Enchantment)enchantmentHolder.value()).getSupportedItems().stream().map(itemHolder -> EmiStack.of((ItemStack)((Item)itemHolder.value()).getDefaultInstance()))).filter(stack -> enchantments.keySet().stream().allMatch(enchantmentHolder -> ((Enchantment)enchantmentHolder.value()).isSupportedItem(stack.getItemStack())))), BuiltInRegistries.ITEM.getOrCreateTag(EnchiridionTags.ItemTags.STORED_ENCHANTABLES).stream().map(itemHolder -> EmiStack.of((ItemStack)((Item)itemHolder.value()).getDefaultInstance()))).toList()))).toList(), EmiStack.of((ItemStack)((SiphoningRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())), ((SiphoningRecipe)recipe.value()).getExperienceCost(), ((SiphoningRecipe)recipe.value()).getTime()));
        }
    }
}

