/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.menu.recipebook;

import house.greenhouse.enchiridion.menu.SiphoningInput;
import house.greenhouse.enchiridion.menu.SiphoningMenu;
import house.greenhouse.enchiridion.menu.recipebook.SiphoningStackedContents;
import house.greenhouse.enchiridion.mixin.Accessor_ServerPlaceRecipe;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiphoningPlaceRecipe
extends ServerPlaceRecipe<SiphoningInput, SiphoningRecipe> {
    private SiphoningStackedContents.RecipePicker recipePicker;

    public SiphoningPlaceRecipe(SiphoningMenu menu) {
        super((RecipeBookMenu)menu);
        ((Accessor_ServerPlaceRecipe)((Object)this)).enchiridion$setStackedContents(new SiphoningStackedContents(menu));
    }

    public void recipeClicked(@NotNull ServerPlayer player, @Nullable RecipeHolder<SiphoningRecipe> recipe, boolean placeAll) {
        RecipeBookMenu recipeBookMenu = this.menu;
        if (recipeBookMenu instanceof SiphoningMenu) {
            SiphoningMenu siphoningMenu = (SiphoningMenu)recipeBookMenu;
            if (recipe != null && ((SiphoningRecipe)recipe.value()).matches(new SiphoningInput((Container)siphoningMenu.getBlockEntity()), player.level())) {
                ((SiphoningStackedContents)this.stackedContents).currentRecipe = recipe.value();
            }
        }
        super.recipeClicked(player, recipe, placeAll);
    }

    protected void handleRecipeClicked(@NotNull RecipeHolder<SiphoningRecipe> recipe, boolean placeAll) {
        IntArrayList intlist;
        int stackSize;
        boolean flag = this.menu.recipeMatches(recipe);
        this.recipePicker = ((SiphoningStackedContents)this.stackedContents).createRecipePicker(recipe.value());
        int i = this.stackedContents.getBiggestCraftableStack(recipe, null);
        if (flag) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemStack;
                if (j == this.menu.getResultSlotIndex() || (itemStack = this.menu.getSlot(j).getItem()).isEmpty() || Math.min(i, itemStack.getMaxStackSize()) >= itemStack.getCount() + (j == 2 ? 1 : ((SiphoningRecipe)recipe.value()).getIngredientsWithAmounts().get(j).amount())) continue;
                return;
            }
        }
        if (this.recipePicker.tryPick(stackSize = this.getStackSize(placeAll, i, flag), (IntList)(intlist = new IntArrayList()))) {
            int k = stackSize;
            IntListIterator intListIterator = intlist.iterator();
            while (intListIterator.hasNext()) {
                int i1;
                int l = (Integer)intListIterator.next();
                ItemStack itemStack1 = StackedContents.fromStackingIndex((int)l);
                if (itemStack1.isEmpty() || (i1 = itemStack1.getMaxStackSize()) >= k) continue;
                k = i1;
            }
            if (this.recipePicker.tryPick(k, (IntList)intlist)) {
                this.clearGrid();
                this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipe, (Iterator)intlist.iterator(), k);
            }
        }
    }

    protected int getStackSize(boolean placeAll, int maxPossible, boolean recipeMatches) {
        int i = 1;
        if (placeAll) {
            i = maxPossible;
        } else if (recipeMatches) {
            i = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                ItemStack itemStack;
                if (j == this.menu.getResultSlotIndex() || (itemStack = this.menu.getSlot(j).getItem()).isEmpty() || i <= itemStack.getCount()) continue;
                i = itemStack.getCount() / this.recipePicker.getItemCount(itemStack);
            }
            if (i != Integer.MAX_VALUE) {
                ++i;
            }
        }
        return i;
    }

    public void addItemToSlot(@NotNull Integer item, int slotIndex, int maxAmount, int x, int y) {
        Slot slot = this.menu.getSlot(slotIndex);
        ItemStack itemStack = StackedContents.fromStackingIndex((int)item);
        if (!itemStack.isEmpty()) {
            int i = maxAmount * this.recipePicker.getItemCount(item);
            while (i > 0) {
                if ((i = this.moveItemToGrid(slot, itemStack, i)) != -1) continue;
                return;
            }
        }
    }
}

