/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParamSets;
import house.greenhouse.enchiridion.api.registry.EnchiridionLootContextParams;
import house.greenhouse.enchiridion.util.EnchantingTableUtil;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={EnchantmentHelper.class})
public abstract class Mixin_EnchantmentHelper {
    @Shadow
    private static void runIterationOnEquipment(LivingEntity entity, EnchantmentHelper.EnchantmentInSlotVisitor enchantmentVisitor) {
    }

    @ModifyReturnValue(method={"getEnchantmentCost"}, at={@At(value="RETURN")})
    private static int enchiridion$modifyEnchantmentCost(int original, @Local(argsOnly=true, ordinal=0) int enchantNum) {
        if (((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().modifyEnchantingTableLogic()) {
            return Math.max(enchantNum + 1, EnchantingTableUtil.getEnchantmentCost(original));
        }
        return original;
    }

    @ModifyReturnValue(method={"updateEnchantments"}, at={@At(value="RETURN")})
    private static ItemEnchantments enchiridion$updateAndValidateCategories(ItemEnchantments enchantments, ItemStack stack, Consumer<ItemEnchantments.Mutable> consumer, @Local DataComponentType<ItemEnchantments> componentType) {
        EnchantmentCategoryUtil.categoriseEnchantmentsOnItem(enchantments, stack, componentType);
        return enchantments;
    }

    @ModifyVariable(method={"getDamageProtection"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;runIterationOnEquipment(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V", shift=At.Shift.AFTER))
    private static MutableFloat enchiridion$addVehicleProtection(MutableFloat original, ServerLevel level, LivingEntity entity, DamageSource source) {
        Entity entity2 = entity.getFirstPassenger();
        if (!(entity2 instanceof LivingEntity)) {
            return original;
        }
        LivingEntity passenger = (LivingEntity)entity2;
        LootParams.Builder params = new LootParams.Builder(level);
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)passenger);
        params.withParameter(EnchiridionLootContextParams.VEHICLE, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        params.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source);
        params.withOptionalParameter(EnchiridionLootContextParams.FIRST_PASSENGER, (Object)passenger.getFirstPassenger());
        params.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        params.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity());
        Mixin_EnchantmentHelper.runIterationOnEquipment(passenger, (enchantment, l, enchantedItem) -> {
            params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)l);
            LootContext lootContext = new LootContext.Builder(params.create(EnchiridionLootContextParamSets.ENCHANTED_VEHICLE_DAMAGE)).create(Optional.empty());
            for (ConditionalEffect conditionalEffect : ((Enchantment)enchantment.value()).getEffects(EnchiridionEnchantmentEffectComponents.VEHICLE_DAMAGE_PROTECTION)) {
                if (!conditionalEffect.matches(lootContext)) continue;
                original.setValue(((EnchantmentValueEffect)conditionalEffect.effect()).process(l, entity.getRandom(), original.floatValue()));
            }
        });
        return original;
    }
}

